/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.config;

import java.util.EnumMap;
import java.util.Map;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.ConfigHandler;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.config.Message;

public class ConfigManager {
    private final Map<ConfigType, ConfigHandler> configurations = new EnumMap<ConfigType, ConfigHandler>(ConfigType.class);

    public void loadFiles(AkropolisPlugin plugin) {
        this.registerFile(ConfigType.SETTINGS, new ConfigHandler(plugin, "config"));
        this.registerFile(ConfigType.MESSAGES, new ConfigHandler(plugin, "messages"));
        this.registerFile(ConfigType.DATA, new ConfigHandler(plugin, "data"));
        this.registerFile(ConfigType.COMMANDS, new ConfigHandler(plugin, "commands"));
        this.configurations.values().forEach(ConfigHandler::saveDefaultConfig);
        Message.setConfiguration(this.getFile(ConfigType.MESSAGES).get());
    }

    public ConfigHandler getFile(ConfigType type) {
        return this.configurations.get((Object)type);
    }

    public void reloadFiles() {
        this.configurations.values().forEach(ConfigHandler::reload);
        Message.setConfiguration(this.getFile(ConfigType.MESSAGES).get());
    }

    public void saveData() {
        this.getFile(ConfigType.DATA).save();
    }

    public void registerFile(ConfigType type, ConfigHandler config) {
        this.configurations.put(type, config);
    }
}

