/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.config;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigHandler {
    private final JavaPlugin plugin;
    private final String name;
    private final File file;
    private FileConfiguration configFile;

    public ConfigHandler(JavaPlugin plugin, String name) {
        this.plugin = plugin;
        this.name = name + ".yml";
        this.file = new File(plugin.getDataFolder(), this.name);
        this.configFile = new YamlConfiguration();
    }

    public void saveDefaultConfig() {
        if (!this.file.exists()) {
            this.plugin.saveResource(this.name, false);
            this.plugin.getLogger().log(Level.INFO, "Resource file {0} written sucessfully!", this.name);
        }
        try {
            this.configFile.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            this.plugin.getLogger().severe("There was an error loading " + this.name);
            this.plugin.getLogger().severe("Please check for any obvious configuration mistakes");
            this.plugin.getLogger().severe("such as using tabs for spaces or forgetting to end quotes");
            this.plugin.getLogger().severe("before reporting to the developer. The plugin will now disable.");
            this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
        }
    }

    public void save() {
        if (this.configFile == null || this.file == null) {
            return;
        }
        try {
            this.configFile.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reload() {
        this.configFile = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public FileConfiguration get() {
        return this.configFile;
    }
}

