/*
 * Decompiled with CFR 0.152.
 */
package team.devblook.akropolis.libs.scoreboardlibrary.implementation.sidebar.line.locale;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.ImmutableTeamProperties;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.PropertiesPacketType;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.team.TeamDisplayPacketAdapter;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.sidebar.line.GlobalLineInfo;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.sidebar.line.SidebarLineHandler;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.sidebar.line.locale.LocaleLine;

public class ModernLocaleLine
implements LocaleLine,
ImmutableTeamProperties<Component> {
    private final GlobalLineInfo info;
    private final SidebarLineHandler handler;
    private final Collection<String> entries;
    private final TeamDisplayPacketAdapter packetAdapter;

    public ModernLocaleLine(GlobalLineInfo info, SidebarLineHandler handler) {
        this.info = info;
        this.handler = handler;
        this.entries = ImmutableList.of((Object)info.player());
        this.packetAdapter = info.packetAdapter().createTeamDisplayAdapter(this);
        this.packetAdapter.updateTeamPackets();
    }

    @Override
    @NotNull
    public GlobalLineInfo info() {
        return this.info;
    }

    @Override
    public void value(@NotNull Component renderedComponent) {
    }

    @Override
    public void updateTeam() {
        this.packetAdapter.updateTeamPackets();
        this.packetAdapter.sendProperties(PropertiesPacketType.UPDATE, this.handler.players());
    }

    @Override
    public void sendScore(@NotNull Collection<Player> players) {
        this.handler.localeLineHandler().sidebar().packetAdapter().sendScore(players, this.info.player(), this.info.objectiveScore(), null, this.info.scoreFormat());
    }

    @Override
    public void show(@NotNull Collection<Player> players) {
        this.sendScore(players);
        this.packetAdapter.sendProperties(PropertiesPacketType.CREATE, players);
    }

    @Override
    public void hide(@NotNull Collection<Player> players) {
        this.handler.localeLineHandler().sidebar().packetAdapter().removeScore(players, this.info.player());
        this.info.packetAdapter().removeTeam(players);
    }

    @Override
    @NotNull
    public Collection<String> syncedEntries() {
        return this.entries;
    }

    @Override
    @NotNull
    public Component displayName() {
        return Component.empty();
    }

    @Override
    @NotNull
    public Component prefix() {
        Component value = this.info.value();
        return value == null ? Component.empty() : value;
    }

    @Override
    @NotNull
    public Component suffix() {
        return Component.empty();
    }
}

