/*
 * Decompiled with CFR 0.152.
 */
package team.devblook.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.util;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.commons.CollectionProvider;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.commons.LocaleProvider;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.PacketSender;

public final class LocalePacketUtil {
    private LocalePacketUtil() {
    }

    public static <P> void sendLocalePackets(@NotNull PacketSender<P> sender, @NotNull Collection<Player> players, @NotNull Function<Locale, P> packetFunction) {
        if (players.isEmpty()) {
            return;
        }
        if (players.size() == 1) {
            Player player = players.iterator().next();
            P packet = packetFunction.apply(LocaleProvider.locale(player));
            sender.sendPacket(player, packet);
            return;
        }
        Map<Locale, Object> map = CollectionProvider.map(1);
        for (Player player : players) {
            Locale locale = LocaleProvider.locale(player);
            Object packet = map.computeIfAbsent(locale, i -> packetFunction.apply(locale));
            sender.sendPacket(player, packet);
        }
    }
}

