/*
 * Decompiled with CFR 0.152.
 */
package team.devblook.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.objective;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Locale;
import java.util.Optional;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.numbers.BlankFormat;
import net.minecraft.network.chat.numbers.FixedFormat;
import net.minecraft.network.chat.numbers.StyledFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.devblook.akropolis.libs.scoreboardlibrary.api.objective.ScoreFormat;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.ComponentProvider;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.modern.PacketAccessors;

public final class ScoreFormatConverter {
    private static final MethodHandle RESULT_UNWRAP_METHOD;

    private ScoreFormatConverter() {
    }

    @Nullable
    public static Object convert(@NotNull ComponentProvider componentProvider, @Nullable Locale locale, @Nullable ScoreFormat format) {
        if (format == null || !PacketAccessors.IS_1_20_3_OR_ABOVE) {
            return null;
        }
        if (format == ScoreFormat.blank()) {
            return BlankFormat.INSTANCE;
        }
        if (format instanceof ScoreFormat.Styled) {
            Style style;
            JsonElement json = GsonComponentSerializer.gson().serializer().toJsonTree((Object)((ScoreFormat.Styled)format).style());
            DataResult result = Style.Serializer.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            try {
                style = (Style)RESULT_UNWRAP_METHOD.invokeExact(result).orElseThrow(RuntimeException::new);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            return new StyledFormat(style);
        }
        if (format instanceof ScoreFormat.Fixed) {
            return new FixedFormat(componentProvider.fromAdventure(((ScoreFormat.Fixed)format).content(), locale));
        }
        throw new IllegalArgumentException("Invalid score format: " + format);
    }

    static {
        try {
            RESULT_UNWRAP_METHOD = MethodHandles.lookup().findVirtual(DataResult.class, "result", MethodType.methodType(Optional.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

