/*
 * Decompiled with CFR 0.152.
 */
package team.devblook.akropolis.libs.scoreboardlibrary.implementation.commons;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyFormat;
import net.kyori.adventure.translation.GlobalTranslator;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.Nullable;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.commons.CollectionProvider;

public final class LegacyFormatUtil {
    private static final Map<NamedTextColor, Character> legacyMap;

    private LegacyFormatUtil() {
    }

    public static String limitLegacyText(String text, int limit) {
        if (text.length() <= limit) {
            return text;
        }
        int lastNotColorCharIndex = limit - 1;
        while (text.charAt(lastNotColorCharIndex) == '\u00a7') {
            --lastNotColorCharIndex;
        }
        return text.substring(0, lastNotColorCharIndex + 1);
    }

    public static String serialize(@Nullable Component component, @Nullable Locale locale) {
        if (component == null || component == Component.empty()) {
            return "";
        }
        Component translated = locale != null ? GlobalTranslator.render((Component)component, (Locale)locale) : component;
        return LegacyComponentSerializer.legacySection().serialize(translated);
    }

    public static char getChar(@Nullable NamedTextColor color) {
        if (color == null) {
            return 'r';
        }
        return legacyMap.getOrDefault(color, Character.valueOf('\u0000')).charValue();
    }

    static {
        ChatColor[] values = ChatColor.values();
        legacyMap = CollectionProvider.map(values.length);
        for (ChatColor value : values) {
            if (!value.isColor()) continue;
            char c = value.getChar();
            LegacyFormat format = Objects.requireNonNull(LegacyComponentSerializer.parseChar((char)c));
            legacyMap.put((NamedTextColor)format.color(), Character.valueOf(c));
        }
    }
}

