/*
 * Decompiled with CFR 0.152.
 */
package team.devblook.akropolis.libs.scoreboardlibrary.implementation;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.devblook.akropolis.libs.scoreboardlibrary.api.ScoreboardLibrary;
import team.devblook.akropolis.libs.scoreboardlibrary.api.exception.NoPacketAdapterAvailableException;
import team.devblook.akropolis.libs.scoreboardlibrary.api.objective.ObjectiveManager;
import team.devblook.akropolis.libs.scoreboardlibrary.api.sidebar.Sidebar;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.PacketAdapterLoader;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.objective.ObjectiveManagerImpl;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.objective.ObjectiveUpdaterTask;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.packetAdapter.PacketAdapterProvider;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.player.LocaleListener;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.player.ScoreboardLibraryPlayer;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.scheduler.TaskScheduler;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.sidebar.AbstractSidebar;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.sidebar.PlayerDependantLocaleSidebar;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.sidebar.SidebarUpdaterTask;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.sidebar.SingleLocaleSidebar;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.team.TeamManagerImpl;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.team.TeamUpdaterTask;

public class ScoreboardLibraryImpl
implements ScoreboardLibrary {
    private final Plugin plugin;
    private final PacketAdapterProvider packetAdapter;
    private final TaskScheduler taskScheduler;
    private final Map<Player, ScoreboardLibraryPlayer> playerMap = new MapMaker().weakKeys().makeMap();
    private volatile Set<TeamManagerImpl> teamManagers;
    private volatile Set<ObjectiveManagerImpl> objectiveManagers;
    private volatile Set<AbstractSidebar> sidebars;
    private final LocaleListener localeListener;
    private TeamUpdaterTask teamTask;
    private ObjectiveUpdaterTask objectiveTask;
    private SidebarUpdaterTask sidebarTask;
    private final Object lock = new Object();
    private volatile boolean closed;

    public ScoreboardLibraryImpl(@NotNull Plugin plugin) throws NoPacketAdapterAvailableException {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        try {
            Class.forName("net.kyori.adventure.Adventure");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Adventure is not in the classpath");
        }
        this.plugin = plugin;
        this.packetAdapter = PacketAdapterLoader.loadPacketAdapter();
        this.taskScheduler = TaskScheduler.create(plugin);
        boolean localeEventExists = false;
        try {
            Class.forName("org.bukkit.event.player.PlayerLocaleChangeEvent");
            localeEventExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (localeEventExists) {
            this.localeListener = new LocaleListener(this);
            plugin.getServer().getPluginManager().registerEvents((Listener)this.localeListener, plugin);
        } else {
            this.localeListener = null;
        }
    }

    @NotNull
    public Plugin plugin() {
        return this.plugin;
    }

    @NotNull
    public PacketAdapterProvider packetAdapter() {
        return this.packetAdapter;
    }

    @NotNull
    public TaskScheduler taskScheduler() {
        return this.taskScheduler;
    }

    @Override
    @NotNull
    public Sidebar createSidebar(int maxLines, @Nullable Locale locale, @NotNull String objectiveName) {
        this.checkClosed();
        if (maxLines <= 0) {
            throw new IllegalArgumentException("invalid maxLines value: " + maxLines);
        }
        AbstractSidebar sidebar = locale == null ? new PlayerDependantLocaleSidebar(this, maxLines, objectiveName) : new SingleLocaleSidebar(this, maxLines, objectiveName, locale);
        this.sidebars().add(sidebar);
        return sidebar;
    }

    @Override
    @NotNull
    public TeamManagerImpl createTeamManager() {
        this.checkClosed();
        TeamManagerImpl teamManager = new TeamManagerImpl(this);
        this.teamManagers().add(teamManager);
        return teamManager;
    }

    @Override
    @NotNull
    public ObjectiveManager createObjectiveManager() {
        this.checkClosed();
        ObjectiveManagerImpl objectiveManager = new ObjectiveManagerImpl(this);
        this.objectiveManagers().add(objectiveManager);
        return objectiveManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        HandlerList.unregisterAll((Listener)this.localeListener);
        if (this.teamManagers != null) {
            this.teamTask.task().cancel();
            object = this.teamTask.lock();
            synchronized (object) {
                for (TeamManagerImpl teamManager : this.teamManagers) {
                    teamManager.close();
                    teamManager.tick();
                }
            }
        }
        if (this.objectiveManagers != null) {
            this.objectiveTask.task().cancel();
            object = this.objectiveTask.lock();
            synchronized (object) {
                for (ObjectiveManagerImpl objectiveManager : this.objectiveManagers) {
                    objectiveManager.close();
                    objectiveManager.tick();
                }
            }
        }
        if (this.sidebars != null) {
            this.sidebarTask.task().cancel();
            object = this.sidebarTask.lock();
            synchronized (object) {
                for (AbstractSidebar sidebar : this.sidebars) {
                    sidebar.close();
                    sidebar.tick();
                }
            }
        }
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TeamManagerImpl> teamManagers() {
        if (this.teamManagers == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.teamManagers == null) {
                    this.teamManagers = Collections.newSetFromMap(new ConcurrentHashMap(4, 0.75f, 2));
                    this.teamTask = new TeamUpdaterTask(this);
                }
            }
        }
        return this.teamManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ObjectiveManagerImpl> objectiveManagers() {
        if (this.objectiveManagers == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.objectiveManagers == null) {
                    this.objectiveManagers = Collections.newSetFromMap(new ConcurrentHashMap(4, 0.75f, 2));
                    this.objectiveTask = new ObjectiveUpdaterTask(this);
                }
            }
        }
        return this.objectiveManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AbstractSidebar> sidebars() {
        if (this.sidebars == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.sidebars == null) {
                    this.sidebars = Collections.newSetFromMap(new ConcurrentHashMap(4, 0.75f, 2));
                    this.sidebarTask = new SidebarUpdaterTask(this);
                }
            }
        }
        return this.sidebars;
    }

    @NotNull
    public ScoreboardLibraryPlayer getOrCreatePlayer(@NotNull Player player) {
        return this.playerMap.computeIfAbsent(player, ScoreboardLibraryPlayer::new);
    }

    @Nullable
    public ScoreboardLibraryPlayer getPlayer(@NotNull Player player) {
        return this.playerMap.get(player);
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("ScoreboardLibrary is closed");
        }
    }
}

