/*
 * Decompiled with CFR 0.152.
 */
package team.devblook.akropolis.libs.scoreboardlibrary.api.team;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.devblook.akropolis.libs.scoreboardlibrary.api.team.ScoreboardTeam;
import team.devblook.akropolis.libs.scoreboardlibrary.api.team.TeamDisplay;

@ApiStatus.NonExtendable
public interface TeamManager {
    @NotNull
    public Collection<ScoreboardTeam> teams();

    @Nullable
    public ScoreboardTeam team(@NotNull String var1);

    public boolean teamExists(@NotNull String var1);

    @NotNull
    default public ScoreboardTeam createIfAbsent(@NotNull String name) {
        return this.createIfAbsent(name, null);
    }

    @NotNull
    public ScoreboardTeam createIfAbsent(@NotNull String var1, @Nullable BiFunction<Player, ScoreboardTeam, TeamDisplay> var2);

    public boolean removeTeam(@NotNull String var1);

    public void removeTeam(@NotNull ScoreboardTeam var1);

    @NotNull
    public Collection<Player> players();

    default public boolean addPlayer(@NotNull Player player) {
        return this.addPlayer(player, null);
    }

    public boolean addPlayer(@NotNull Player var1, @Nullable Function<ScoreboardTeam, TeamDisplay> var2);

    default public void addPlayers(@NotNull Collection<Player> players) {
        this.addPlayers(players, null);
    }

    default public void addPlayers(@NotNull Collection<Player> players, @Nullable Function<ScoreboardTeam, TeamDisplay> teamDisplayFunction) {
        for (Player player : players) {
            this.addPlayer(player, teamDisplayFunction);
        }
    }

    public boolean removePlayer(@NotNull Player var1);

    default public void removePlayers(@NotNull Collection<Player> players) {
        for (Player player : players) {
            this.removePlayer(player);
        }
    }

    public void close();

    public boolean closed();
}

