/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.util.text;

import io.github.miniplaceholders.api.MiniPlaceholders;
import java.util.Stack;
import me.clip.placeholderapi.PlaceholderAPI;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.Message;
import me.zetastormy.akropolis.module.modules.world.SongPlayerManager;
import me.zetastormy.akropolis.util.text.TextUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PlaceholderUtil {
    private static boolean papi = false;
    private static boolean miniplaceholders = false;

    private PlaceholderUtil() {
        throw new UnsupportedOperationException();
    }

    private static String formatLocation(Location loc) {
        return loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ();
    }

    private static String getCurrentSong() {
        SongPlayerManager songPlayerManager = AkropolisPlugin.getInstance().getSongPlayerManager();
        return songPlayerManager != null ? songPlayerManager.getCurrentSong() : "None";
    }

    private static void pushTagResolver(Stack<TagResolver> tagResolvers, String name, Component component) {
        tagResolvers.push(TagResolver.resolver((String)name, (argumentQueue, context) -> Tag.selfClosingInserting((Component)component)));
    }

    private static Stack<TagResolver> globalTagResolver() {
        Stack<TagResolver> tagResolvers = new Stack<TagResolver>();
        PlaceholderUtil.pushTagResolver(tagResolvers, "prefix", TextUtil.parse(Message.PREFIX.raw()));
        PlaceholderUtil.pushTagResolver(tagResolvers, "online", (Component)Component.text((int)Bukkit.getOnlinePlayers().size()));
        PlaceholderUtil.pushTagResolver(tagResolvers, "online_max", (Component)Component.text((int)Bukkit.getMaxPlayers()));
        PlaceholderUtil.pushTagResolver(tagResolvers, "current_song", (Component)Component.text((String)PlaceholderUtil.getCurrentSong()));
        return tagResolvers;
    }

    public static Component setPlaceholders(String rawText) {
        return TextUtil.parseWithPlaceholders(rawText, TagResolver.resolver(PlaceholderUtil.globalTagResolver()));
    }

    public static Component setPlaceholders(String rawText, Audience audience) {
        if (!(audience instanceof Player)) {
            return PlaceholderUtil.setPlaceholders(rawText);
        }
        Player player = (Player)audience;
        Stack<TagResolver> tagResolvers = PlaceholderUtil.globalTagResolver();
        PlaceholderUtil.pushTagResolver(tagResolvers, "player", (Component)Component.text((String)player.getName()));
        PlaceholderUtil.pushTagResolver(tagResolvers, "ping", (Component)Component.text((int)player.getPing()));
        PlaceholderUtil.pushTagResolver(tagResolvers, "world", (Component)Component.text((String)player.getWorld().getName()));
        PlaceholderUtil.pushTagResolver(tagResolvers, "location", (Component)Component.text((String)PlaceholderUtil.formatLocation(player.getLocation())));
        if (papi) {
            tagResolvers.push(PlaceholderUtil.papiTag(player));
        }
        if (miniplaceholders) {
            tagResolvers.push(MiniPlaceholders.audienceGlobalPlaceholders());
        }
        return TextUtil.parse(rawText, (Pointered)audience, TagResolver.resolver(tagResolvers));
    }

    public static TagResolver papiTag(Player player) {
        return TagResolver.resolver((String)"papi", (argumentQueue, context) -> {
            String papiPlaceholder = argumentQueue.popOr("papi tag requires an argument").value();
            String parsedPlaceholder = TextUtil.raw((Component)LegacyComponentSerializer.legacySection().deserialize(ChatColor.translateAlternateColorCodes((char)'&', (String)PlaceholderAPI.setPlaceholders((Player)player, (String)("%" + papiPlaceholder + "%")))));
            return Tag.selfClosingInserting((Component)TextUtil.parse(parsedPlaceholder));
        });
    }

    public static void setPapiState(boolean papiState) {
        papi = papiState;
    }

    public static void setMPState(boolean miniplaceholdersState) {
        miniplaceholders = miniplaceholdersState;
    }
}

