/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.world;

import com.xxmicloxx.NoteBlockAPI.event.SongNextEvent;
import com.xxmicloxx.NoteBlockAPI.model.FadeType;
import com.xxmicloxx.NoteBlockAPI.model.Playlist;
import com.xxmicloxx.NoteBlockAPI.model.RepeatMode;
import com.xxmicloxx.NoteBlockAPI.model.Song;
import com.xxmicloxx.NoteBlockAPI.model.playmode.ChannelMode;
import com.xxmicloxx.NoteBlockAPI.model.playmode.MonoStereoMode;
import com.xxmicloxx.NoteBlockAPI.model.playmode.StereoMode;
import com.xxmicloxx.NoteBlockAPI.songplayer.Fade;
import com.xxmicloxx.NoteBlockAPI.songplayer.PositionSongPlayer;
import com.xxmicloxx.NoteBlockAPI.songplayer.RadioSongPlayer;
import com.xxmicloxx.NoteBlockAPI.songplayer.SongPlayer;
import com.xxmicloxx.NoteBlockAPI.utils.NBSDecoder;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.ConfigHandler;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class SongPlayerManager
extends Module
implements LifeCycle {
    private SongPlayer songPlayer;
    private ConfigHandler dataConfig;
    private List<String> actions;

    public SongPlayerManager(AkropolisPlugin plugin) {
        super(plugin, ModuleType.SONG_PLAYER);
    }

    @Override
    public void onEnable() {
        if (!this.getPlugin().getHookManager().isHookEnabled("NOTEBLOCK_API")) {
            this.getPlugin().getLogger().warning("NoteBlockAPI is not enabled! The songs module won't be enabled.");
            return;
        }
        Playlist playlist = this.loadSongs();
        if (playlist == null) {
            this.getPlugin().getLogger().warning("Songs' directory is empty! The songs module won't be enabled.");
            return;
        }
        this.dataConfig = this.getPlugin().getConfigManager().getFile(ConfigType.DATA);
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        String type = config.getString("song_player.type", "RADIO");
        int distance = config.getInt("song_player.distance", 16);
        this.actions = config.getStringList("song_player.actions");
        int fadeInDuration = config.getInt("song_player.fade.in", 20);
        int fadeOutDuration = config.getInt("song_player.fade.out", 20);
        byte volume = (byte)config.getInt("song_player.volume", 85);
        this.songPlayer = this.createSongPlayer(playlist, type, distance);
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.getPlugin(), () -> Bukkit.getOnlinePlayers().stream().filter(player -> !this.inDisabledWorld(player.getLocation())).forEach(arg_0 -> ((SongPlayer)this.songPlayer).addPlayer(arg_0)), 20L);
        Fade fadeIn = this.songPlayer.getFadeIn();
        Fade fadeOut = this.songPlayer.getFadeOut();
        fadeIn.setType(FadeType.LINEAR);
        fadeOut.setType(FadeType.LINEAR);
        fadeIn.setFadeDuration(fadeInDuration);
        fadeOut.setFadeDuration(fadeOutDuration);
        this.songPlayer.setVolume(volume);
        this.songPlayer.setRepeatMode(RepeatMode.ALL);
        this.songPlayer.setPlaying(true);
    }

    @Override
    public void onDisable() {
        if (this.songPlayer != null) {
            this.songPlayer.destroy();
        }
    }

    private Playlist loadSongs() {
        File directory = new File(this.getPlugin().getDataFolder().getAbsolutePath() + File.separator + "songs");
        if (!directory.exists() && !directory.mkdir()) {
            this.getPlugin().getLogger().severe("Could not create songs' directory!");
            this.getPlugin().getLogger().severe("The plugin will now disable.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.getPlugin());
            return null;
        }
        File[] nbsFiles = new File(this.getPlugin().getDataFolder().getAbsolutePath() + File.separator + "songs").listFiles((dir, name) -> name.toLowerCase().endsWith(".nbs"));
        HashSet<Song> songs = new HashSet<Song>();
        for (File song : nbsFiles) {
            songs.add(NBSDecoder.parse((File)song));
        }
        if (songs.isEmpty()) {
            return null;
        }
        return new Playlist(songs.toArray(new Song[0]));
    }

    private RadioSongPlayer createRadioSongPlayer(Playlist playlist) {
        RadioSongPlayer radioSongPlayer = new RadioSongPlayer(playlist);
        StereoMode stereoMode = new StereoMode();
        stereoMode.setFallbackChannelMode((ChannelMode)new MonoStereoMode());
        radioSongPlayer.setChannelMode((ChannelMode)stereoMode);
        return radioSongPlayer;
    }

    private SongPlayer createSongPlayer(Playlist playlist, String type, int distance) {
        if (type.equalsIgnoreCase("RADIO")) {
            return this.createRadioSongPlayer(playlist);
        }
        Location songLocation = this.dataConfig.get().getLocation("song_player.location");
        if (songLocation == null) {
            this.getPlugin().getLogger().warning("Couldn't get song player location! Using radio song player instead.");
            return this.createRadioSongPlayer(playlist);
        }
        PositionSongPlayer songPlayer = new PositionSongPlayer(playlist);
        songPlayer.setTargetLocation(songLocation);
        songPlayer.setDistance(distance);
        return songPlayer;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.songPlayer == null || this.inDisabledWorld(event.getPlayer().getLocation())) {
            return;
        }
        this.songPlayer.addPlayer(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.songPlayer == null) {
            return;
        }
        this.songPlayer.removePlayer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWorldChange(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        World fromWorld = event.getFrom().getWorld();
        World toWorld = event.getTo().getWorld();
        if (toWorld == null) {
            return;
        }
        if (fromWorld == toWorld) {
            return;
        }
        if (this.inDisabledWorld(toWorld)) {
            this.songPlayer.removePlayer(player);
        } else {
            this.songPlayer.addPlayer(player);
        }
    }

    @EventHandler
    public void onSongNext(SongNextEvent event) {
        if (this.songPlayer == null) {
            return;
        }
        this.songPlayer.getPlayerUUIDs().forEach(uuid -> this.executeActions(this.getPlugin().getServer().getPlayer(uuid), this.actions));
    }

    public void setLocation(Location location) {
        this.dataConfig.get().set("song_player.location", (Object)location);
        this.dataConfig.save();
    }

    public void skip() {
        if (this.songPlayer == null) {
            return;
        }
        this.songPlayer.playNextSong();
    }

    public String getCurrentSong() {
        if (this.songPlayer == null) {
            return "";
        }
        return this.songPlayer.getSong().getTitle();
    }

    public SongPlayer getSongPlayer() {
        return this.songPlayer;
    }
}

