/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.world;

import com.cryptomorin.xseries.XMaterial;
import java.util.List;
import java.util.Objects;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class Launchpad
extends Module
implements LifeCycle {
    private double launch;
    private double launchY;
    private List<String> actions;
    private Material topBlock;
    private Material bottomBlock;

    public Launchpad(AkropolisPlugin plugin) {
        super(plugin, ModuleType.LAUNCHPAD);
    }

    @Override
    public void onEnable() {
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.launch = config.getDouble("launchpad.launch_power", 1.3);
        this.launchY = config.getDouble("launchpad.launch_power_y", 1.2);
        this.actions = config.getStringList("launchpad.actions");
        if (this.launch > 4.0) {
            this.launch = 4.0;
        }
        if (this.launchY > 4.0) {
            this.launchY = 4.0;
        }
        String rawTopBlock = config.getString("launchpad.top_block");
        String rawBottomBlock = config.getString("launchpad.bottom_block");
        if (rawTopBlock == null) {
            this.getPlugin().getLogger().severe("Launchpad' top block is missing, using air item!");
            XMaterial.matchXMaterial((String)"AIR").ifPresent(m -> {
                this.topBlock = m.get();
            });
        } else {
            XMaterial.matchXMaterial((String)rawTopBlock).ifPresent(m -> {
                this.topBlock = m.get();
            });
        }
        if (rawBottomBlock == null) {
            this.getPlugin().getLogger().severe("Launchpad' bottom block is missing, using air item!");
            XMaterial.matchXMaterial((String)"AIR").ifPresent(m -> {
                this.bottomBlock = m.get();
            });
        } else {
            XMaterial.matchXMaterial((String)rawBottomBlock).ifPresent(m -> {
                this.bottomBlock = m.get();
            });
        }
    }

    @EventHandler
    public void onLaunchPadInteract(PlayerInteractEvent event) {
        if (!event.hasBlock() || event.getAction() != Action.PHYSICAL) {
            return;
        }
        Player player = event.getPlayer();
        Location playerLocation = player.getLocation();
        Location blockLocation = Objects.requireNonNull(event.getClickedBlock()).getLocation();
        if (this.inDisabledWorld(blockLocation)) {
            return;
        }
        if (blockLocation.getBlock().getType() == this.topBlock && blockLocation.subtract(0.0, 1.0, 0.0).getBlock().getType() == this.bottomBlock && this.tryCooldown(player.getUniqueId(), "launchpad", 1L)) {
            player.setVelocity(playerLocation.getDirection().multiply(this.launch).setY(this.launchY));
            this.executeActions(player, this.actions);
        }
    }
}

