/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.player;

import java.util.List;
import java.util.UUID;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.Permissions;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.config.Message;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;

public class PlayerMount
extends Module
implements LifeCycle {
    private List<String> actions;
    private long cooldownDelay;

    public PlayerMount(AkropolisPlugin plugin) {
        super(plugin, ModuleType.PLAYER_MOUNT);
    }

    @Override
    public void onEnable() {
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.actions = config.getStringList("player_mount.actions");
        this.cooldownDelay = config.getLong("player_mount.cooldown", 5L);
    }

    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        Player player = event.getPlayer();
        Entity clickedEntity = event.getRightClicked();
        if (!(clickedEntity instanceof Player)) {
            return;
        }
        if (player.hasPermission(Permissions.EVENT_PLAYER_MOUNT.getPermission())) {
            UUID uuid = player.getUniqueId();
            if (!this.tryCooldown(uuid, "player_mount", this.cooldownDelay)) {
                Message.PLAYER_MOUNT_COOLDOWN.sendWithReplacement((Audience)player, "time", (Component)Component.text((long)this.getCooldown(uuid, "player_mount")));
                return;
            }
            if (clickedEntity.addPassenger((Entity)player)) {
                this.executeActions(player, this.actions);
            }
        }
    }
}

