/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.hotbar;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import me.zetastormy.akropolis.module.modules.hotbar.HotbarItem;
import me.zetastormy.akropolis.module.modules.hotbar.items.CustomItem;
import me.zetastormy.akropolis.module.modules.hotbar.items.FightMode;
import me.zetastormy.akropolis.module.modules.hotbar.items.PlayerHider;
import me.zetastormy.akropolis.util.ItemStackBuilder;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HotbarManager
extends Module
implements LifeCycle {
    private List<HotbarItem> hotbarItems;
    private Set<UUID> players;

    public HotbarManager(AkropolisPlugin plugin) {
        super(plugin, ModuleType.HOTBAR_ITEMS);
    }

    @Override
    public void onEnable() {
        ConfigurationSection fightModeSection;
        this.hotbarItems = new ArrayList<HotbarItem>();
        this.players = new HashSet<UUID>();
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        ConfigurationSection customItemsSections = config.getConfigurationSection("custom_join_items");
        if (customItemsSections == null) {
            this.getPlugin().getLogger().severe("Custom join items configuration section is missing!");
            return;
        }
        if (customItemsSections.getBoolean("enabled")) {
            this.registerCustomItems(customItemsSections);
        }
        if ((fightModeSection = config.getConfigurationSection("fight_mode")) == null) {
            this.getPlugin().getLogger().severe("Fight mode item configuration section is missing!");
        } else if (fightModeSection.getBoolean("enabled")) {
            ItemStack item = ItemStackBuilder.getItemStack(fightModeSection.getConfigurationSection("item")).build();
            FightMode fightMode = new FightMode(this, item, fightModeSection.getInt("slot"), "FIGHT_MODE_ITEM");
            fightMode.setDisableMovement(fightModeSection.getBoolean("disable_inventory_movement"));
            this.registerHotbarItem(fightMode);
        }
        ConfigurationSection hiderSection = config.getConfigurationSection("player_hider");
        if (hiderSection == null) {
            this.getPlugin().getLogger().severe("Player hider item configuration section is missing!");
        } else if (hiderSection.getBoolean("enabled")) {
            boolean playersHidden = config.getBoolean("join_settings.players_hidden", false);
            ItemStack item = playersHidden ? ItemStackBuilder.getItemStack(hiderSection.getConfigurationSection("hidden")).build() : ItemStackBuilder.getItemStack(hiderSection.getConfigurationSection("not_hidden")).build();
            PlayerHider playerHider = new PlayerHider(this, item, hiderSection.getInt("slot"), "PLAYER_HIDER");
            playerHider.setDisableMovement(hiderSection.getBoolean("disable_inventory_movement"));
            this.registerHotbarItem(playerHider);
        }
        this.giveItems();
    }

    @Override
    public void onDisable() {
        this.removeItems();
    }

    private void registerCustomItems(ConfigurationSection customItemsSection) {
        ConfigurationSection itemsSection = customItemsSection.getConfigurationSection("items");
        if (itemsSection == null) {
            this.getPlugin().getLogger().severe("Items of custom join items configuration section is missing!");
            return;
        }
        for (String itemEntry : itemsSection.getKeys(false)) {
            ItemStack item = ItemStackBuilder.getItemStack(itemsSection.getConfigurationSection(itemEntry)).build();
            CustomItem customItem = new CustomItem(this, item, itemsSection.getInt(itemEntry + ".slot"), itemEntry);
            if (itemsSection.contains(itemEntry + ".permission")) {
                customItem.setPermission(itemsSection.getString(itemEntry + ".permission"));
            }
            customItem.setConfigurationSection(itemsSection.getConfigurationSection(itemEntry));
            customItem.setDisableMovement(customItemsSection.getBoolean("disable_inventory_movement"));
            this.registerHotbarItem(customItem);
        }
    }

    public void registerHotbarItem(HotbarItem hotbarItem) {
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)hotbarItem, (Plugin)this.getPlugin());
        this.hotbarItems.add(hotbarItem);
    }

    private void giveItems() {
        Bukkit.getOnlinePlayers().forEach(this::giveItemsToPlayer);
    }

    private void removeItems() {
        Bukkit.getOnlinePlayers().forEach(this::removeItemsFromPlayer);
    }

    public void giveItemsToPlayer(Player player) {
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        this.hotbarItems.forEach(hotbarItem -> hotbarItem.giveItem(player));
    }

    public void removeItemsFromPlayer(Player player) {
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        this.hotbarItems.forEach(hotbarItem -> hotbarItem.removeItem(player));
    }

    public boolean hasHotbar(UUID playerUuid) {
        return this.players.contains(playerUuid);
    }

    public List<HotbarItem> getHotbarItems() {
        return this.hotbarItems;
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }
}

