/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.chat.groups;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.configuration.ConfigurationSection;

public class Emojis {
    private final Map<String, Set<String>> emoticonToEmojis;
    private final Pattern emojiPattern;

    public Emojis(ConfigurationSection emojiSection) {
        if (emojiSection == null) {
            this.emoticonToEmojis = Map.of();
            this.emojiPattern = Pattern.compile("");
            return;
        }
        this.emoticonToEmojis = new HashMap<String, Set<String>>();
        emojiSection.getKeys(false).forEach(key -> {
            List<String> emoticons;
            Set<Object> emoji = new HashSet(emojiSection.getStringList(key + ".emoji"));
            if (emoji.isEmpty()) {
                emoji = Set.of(emojiSection.getString(key + ".emoji"));
            }
            if ((emoticons = emojiSection.getStringList(key + ".emoticon")).isEmpty()) {
                emoticons = List.of(emojiSection.getString(key + ".emoticon"));
            }
            for (String emoticon : emoticons) {
                this.emoticonToEmojis.put(emoticon, emoji);
            }
        });
        List<String> escapedEmoticons = this.emoticonToEmojis.keySet().stream().sorted(Comparator.comparingInt(String::length).reversed()).map(Pattern::quote).toList();
        this.emojiPattern = Pattern.compile(String.join((CharSequence)"|", escapedEmoticons));
    }

    public String parse(String text) {
        Matcher matcher = this.emojiPattern.matcher(text);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String found = matcher.group();
            Set<String> emojiSet = this.emoticonToEmojis.get(found);
            if (emojiSet == null || emojiSet.isEmpty()) continue;
            String replacement = this.getRandomEmoji(emojiSet);
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private String getRandomEmoji(Set<String> emojis) {
        int index = new Random().nextInt(emojis.size());
        return emojis.stream().skip(index).findFirst().orElse("");
    }
}

