/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.chat;

import io.papermc.paper.event.player.AsyncChatEvent;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.Permissions;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.config.Message;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import net.kyori.adventure.audience.Audience;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;

public class ChatLock
extends Module
implements LifeCycle {
    private boolean isChatLocked;

    public ChatLock(AkropolisPlugin plugin) {
        super(plugin, ModuleType.CHAT_LOCK);
    }

    @Override
    public void onEnable() {
        this.isChatLocked = this.getPlugin().getConfigManager().getFile(ConfigType.DATA).get().getBoolean("chat_locked");
    }

    @Override
    public void onDisable() {
        this.getPlugin().getConfigManager().getFile(ConfigType.DATA).get().set("chat_locked", (Object)this.isChatLocked);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        if (!this.isChatLocked || player.hasPermission(Permissions.LOCK_CHAT_BYPASS.getPermission())) {
            return;
        }
        event.setCancelled(true);
        Message.CHAT_LOCKED.send((Audience)player);
    }

    public boolean isChatLocked() {
        return this.isChatLocked;
    }

    public void setChatLocked(boolean chatLocked) {
        this.isChatLocked = chatLocked;
    }
}

