/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.cooldown.CooldownManager;
import me.zetastormy.akropolis.module.ModuleType;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class Module
implements Listener {
    private final AkropolisPlugin plugin;
    private final ModuleType moduleType;
    private List<String> disabledWorlds;
    private final CooldownManager cooldownManager;

    protected Module(AkropolisPlugin plugin, ModuleType type) {
        this.plugin = plugin;
        this.moduleType = type;
        this.cooldownManager = plugin.getCooldownManager();
        this.disabledWorlds = new ArrayList<String>();
    }

    public void setDisabledWorlds(List<String> disabledWorlds) {
        this.disabledWorlds = disabledWorlds;
    }

    public AkropolisPlugin getPlugin() {
        return this.plugin;
    }

    public boolean inDisabledWorld(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        return this.disabledWorlds.contains(world.getName());
    }

    public boolean inDisabledWorld(World world) {
        return this.disabledWorlds.contains(world.getName());
    }

    public boolean tryCooldown(UUID uuid, String type, long delay) {
        return this.cooldownManager.tryCooldown(uuid, type, delay);
    }

    public long getCooldown(UUID uuid, String type) {
        return this.cooldownManager.getCooldown(uuid, type) / 1000L;
    }

    public FileConfiguration getConfig(ConfigType type) {
        return this.getPlugin().getConfigManager().getFile(type).get();
    }

    public void executeActions(Player player, List<String> actions) {
        this.getPlugin().getActionManager().executeActions(player, actions);
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }
}

