/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.inventory.InventoryBuilder;
import me.zetastormy.akropolis.inventory.InventoryTask;
import me.zetastormy.akropolis.util.ItemStackBuilder;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public abstract class AbstractInventory
implements Listener {
    private final AkropolisPlugin plugin;
    private boolean refreshEnabled = false;
    private final List<UUID> openInventories;

    protected AbstractInventory(AkropolisPlugin plugin) {
        this.plugin = plugin;
        this.openInventories = new ArrayList<UUID>();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void setInventoryRefresh(long value) {
        if (value <= 0L) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, (Runnable)new InventoryTask(this), 0L, value);
        this.refreshEnabled = true;
    }

    public abstract void onEnable();

    protected abstract Inventory getInventory();

    protected AkropolisPlugin getPlugin() {
        return this.plugin;
    }

    public Inventory refreshInventory(Player player, Inventory inventory) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemMeta itemMeta;
            PersistentDataContainer container;
            ItemStack item = this.getInventory().getItem(i);
            if (item == null || item.getType() == Material.AIR || item.getItemMeta() == null || !item.hasItemMeta()) continue;
            ItemStackBuilder newItem = new ItemStackBuilder(item.clone());
            if (item.getItemMeta().hasDisplayName()) {
                newItem.withName(item.getItemMeta().displayName(), player);
            }
            if (item.getItemMeta().hasLore() && item.getItemMeta().lore() != null) {
                newItem.withLore(item.getItemMeta().lore(), player);
            }
            if (item.getType() == Material.PLAYER_HEAD && (container = (itemMeta = item.getItemMeta()).getPersistentDataContainer()).has(NamespacedKey.minecraft((String)"player-head"), PersistentDataType.BOOLEAN)) {
                newItem.setSkullOwner((OfflinePlayer)player);
            }
            inventory.setItem(i, newItem.build());
        }
        return inventory;
    }

    public void openInventory(Player player) {
        if (this.getInventory() == null) {
            return;
        }
        player.openInventory(this.refreshInventory(player, this.getInventory()));
        if (this.refreshEnabled && !this.openInventories.contains(player.getUniqueId())) {
            this.openInventories.add(player.getUniqueId());
        }
    }

    public List<UUID> getOpenInventories() {
        return this.openInventories;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getView().getTopInventory().getHolder() instanceof InventoryBuilder && this.refreshEnabled) {
            this.openInventories.remove(event.getPlayer().getUniqueId());
        }
    }
}

