/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.command.commands.gamemode;

import java.util.List;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.Permissions;
import me.zetastormy.akropolis.command.InjectableCommand;
import me.zetastormy.akropolis.config.Message;
import me.zetastormy.akropolis.util.text.TextUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GamemodeCommand
extends InjectableCommand {
    public GamemodeCommand(AkropolisPlugin plugin, List<String> aliases) {
        super((Plugin)plugin, "gamemode", "Allows you to change gamemode", "/gamemode <gamemode> [player]", aliases);
    }

    @Override
    public void onCommand(CommandSender sender, String label, String[] args) {
        if (args.length == 1) {
            if (!(sender instanceof Player)) {
                Message.CONSOLE_NOT_ALLOWED.send((Audience)sender);
                return;
            }
            Player player = (Player)sender;
            if (!player.hasPermission(Permissions.COMMAND_GAMEMODE.getPermission())) {
                Message.NO_PERMISSION.send((Audience)sender);
                return;
            }
            GameMode gamemode = this.getGamemode(args[0]);
            if (gamemode == null) {
                Message.GAMEMODE_INVALID.sendWithReplacement((Audience)sender, "gamemode", TextUtil.parse(args[0]));
                return;
            }
            Message.GAMEMODE_CHANGE.sendWithReplacement((Audience)player, "gamemode", TextUtil.parse(gamemode.toString().toUpperCase()));
            player.setGameMode(gamemode);
        } else if (args.length == 2) {
            if (!sender.hasPermission(Permissions.COMMAND_GAMEMODE_OTHERS.getPermission())) {
                Message.NO_PERMISSION.send((Audience)sender);
                return;
            }
            Player player = Bukkit.getPlayer((String)args[1]);
            if (player == null) {
                Message.INVALID_PLAYER.sendWithReplacement((Audience)sender, "player", TextUtil.parse(args[0]));
                return;
            }
            GameMode gamemode = this.getGamemode(args[0]);
            if (gamemode == null) {
                Message.GAMEMODE_INVALID.sendWithReplacement((Audience)sender, "gamemode", TextUtil.parse(args[0]));
                return;
            }
            Component gamemodeChange = TextUtil.replace(Message.GAMEMODE_CHANGE.toComponent(), "gamemode", TextUtil.parse(gamemode.toString().toUpperCase()));
            if (sender.getName().equals(player.getName())) {
                player.sendMessage(gamemodeChange);
            } else {
                player.sendMessage(gamemodeChange);
                sender.sendMessage(TextUtil.replace(TextUtil.replace(Message.GAMEMODE_CHANGE_OTHER.toComponent(), "player", player.name()), "gamemode", TextUtil.parse(gamemode.toString().toUpperCase())));
            }
            player.setGameMode(gamemode);
        }
    }

    private GameMode getGamemode(String gamemode) {
        if (gamemode.equals("0") || gamemode.equalsIgnoreCase("survival") || gamemode.equalsIgnoreCase("s")) {
            return GameMode.SURVIVAL;
        }
        if (gamemode.equals("1") || gamemode.equalsIgnoreCase("creative") || gamemode.equalsIgnoreCase("c")) {
            return GameMode.CREATIVE;
        }
        if (gamemode.equals("2") || gamemode.equalsIgnoreCase("adventure") || gamemode.equalsIgnoreCase("a")) {
            return GameMode.ADVENTURE;
        }
        if (gamemode.equals("3") || gamemode.equalsIgnoreCase("spectator") || gamemode.equalsIgnoreCase("sp")) {
            return GameMode.SPECTATOR;
        }
        return null;
    }
}

