/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.command.commands;

import java.util.List;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.Permissions;
import me.zetastormy.akropolis.command.InjectableCommand;
import me.zetastormy.akropolis.config.Message;
import me.zetastormy.akropolis.module.ModuleType;
import me.zetastormy.akropolis.module.modules.world.LobbySpawn;
import me.zetastormy.akropolis.util.text.TextUtil;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SetLobbyCommand
extends InjectableCommand {
    private final AkropolisPlugin plugin;

    public SetLobbyCommand(AkropolisPlugin plugin, List<String> aliases) {
        super((Plugin)plugin, "setlobby", "Set the lobby location", aliases);
        this.plugin = plugin;
    }

    @Override
    public void onCommand(CommandSender sender, String label, String[] args) {
        if (!sender.hasPermission(Permissions.COMMAND_SET_LOBBY.getPermission())) {
            Message.NO_PERMISSION.send((Audience)sender);
            return;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("Console cannot set the spawn location.");
            return;
        }
        Player player = (Player)sender;
        if (this.plugin.getModuleManager().getDisabledWorlds().contains(player.getWorld().getName())) {
            sender.sendMessage(TextUtil.parse("<red>You cannot set the lobby location in a disabled world."));
            return;
        }
        LobbySpawn lobbyModule = (LobbySpawn)this.plugin.getModuleManager().getModule(ModuleType.LOBBY);
        lobbyModule.setLocation(player.getLocation());
        Message.SET_LOBBY.send((Audience)sender);
    }
}

