/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.command.commands;

import java.util.List;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.Permissions;
import me.zetastormy.akropolis.command.InjectableCommand;
import me.zetastormy.akropolis.config.ConfigManager;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.config.Message;
import me.zetastormy.akropolis.util.text.TextUtil;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FlyCommand
extends InjectableCommand {
    private final AkropolisPlugin plugin;
    private final FileConfiguration dataConfig;
    private final boolean saveState;

    public FlyCommand(AkropolisPlugin plugin, List<String> aliases) {
        super((Plugin)plugin, "fly", "Toggle flight mode", "/fly [player]", aliases);
        this.plugin = plugin;
        ConfigManager configManager = plugin.getConfigManager();
        this.dataConfig = configManager.getFile(ConfigType.DATA).get();
        this.saveState = configManager.getFile(ConfigType.SETTINGS).get().getBoolean("fly.save_state", false);
    }

    @Override
    public void onCommand(CommandSender sender, String label, String[] args) {
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                Message.CONSOLE_NOT_ALLOWED.send((Audience)sender);
                return;
            }
            Player player = (Player)sender;
            if (!sender.hasPermission(Permissions.COMMAND_FLIGHT.getPermission())) {
                Message.NO_PERMISSION.send((Audience)sender);
                return;
            }
            if (player.getAllowFlight()) {
                Message.FLIGHT_DISABLE.send((Audience)player);
                this.toggleFlight(player, false);
            } else {
                Message.FLIGHT_ENABLE.send((Audience)player);
                this.toggleFlight(player, true);
            }
        } else if (args.length == 1) {
            if (!sender.hasPermission(Permissions.COMMAND_FLIGHT_OTHERS.getPermission())) {
                Message.NO_PERMISSION.send((Audience)sender);
                return;
            }
            Player player = Bukkit.getPlayer((String)args[0]);
            if (player == null) {
                Message.INVALID_PLAYER.sendWithReplacement((Audience)sender, "player", TextUtil.parse(args[0]));
                return;
            }
            if (player.getAllowFlight()) {
                Message.FLIGHT_DISABLE.send((Audience)player);
                Message.FLIGHT_DISABLE_OTHER.sendWithReplacement((Audience)sender, "player", player.name());
                this.toggleFlight(player, false);
            } else {
                Message.FLIGHT_ENABLE.send((Audience)player);
                Message.FLIGHT_ENABLE_OTHER.sendWithReplacement((Audience)sender, "player", player.name());
                this.toggleFlight(player, true);
            }
        }
    }

    private void toggleFlight(Player player, boolean value) {
        player.setAllowFlight(value);
        player.setFlying(value);
        if (!this.saveState) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.dataConfig.set("players." + String.valueOf(player.getUniqueId()) + ".fly", (Object)value));
    }
}

