/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.action;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.action.Action;
import me.zetastormy.akropolis.action.actions.ActionbarAction;
import me.zetastormy.akropolis.action.actions.BroadcastMessageAction;
import me.zetastormy.akropolis.action.actions.CloseInventoryAction;
import me.zetastormy.akropolis.action.actions.CommandAction;
import me.zetastormy.akropolis.action.actions.ConsoleCommandAction;
import me.zetastormy.akropolis.action.actions.GamemodeAction;
import me.zetastormy.akropolis.action.actions.MenuAction;
import me.zetastormy.akropolis.action.actions.MessageAction;
import me.zetastormy.akropolis.action.actions.PotionEffectAction;
import me.zetastormy.akropolis.action.actions.ServerAction;
import me.zetastormy.akropolis.action.actions.SoundAction;
import me.zetastormy.akropolis.action.actions.TitleAction;
import me.zetastormy.akropolis.util.text.PlaceholderUtil;
import me.zetastormy.akropolis.util.text.TextUtil;
import net.kyori.adventure.audience.Audience;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.entity.Player;

public class ActionManager {
    private final AkropolisPlugin plugin;
    private final Map<String, Action> actions;

    public ActionManager(AkropolisPlugin plugin) {
        this.plugin = plugin;
        this.actions = new HashMap<String, Action>();
        this.load();
    }

    private void load() {
        this.registerAction(new MessageAction(), new BroadcastMessageAction(), new CommandAction(), new ConsoleCommandAction(), new SoundAction(), new PotionEffectAction(), new GamemodeAction(), new ServerAction(), new CloseInventoryAction(), new ActionbarAction(), new TitleAction(), new MenuAction());
    }

    public void registerAction(Action ... actions) {
        Arrays.asList(actions).forEach(action -> this.actions.put(action.getIdentifier(), (Action)action));
    }

    public void executeActions(Player player, List<String> actions) {
        actions.forEach(actionContent -> {
            Action action;
            if (actionContent == null || actionContent.equals("")) {
                return;
            }
            String actionName = StringUtils.substringBetween((String)actionContent, (String)"[", (String)"]").toUpperCase();
            Action action2 = action = actionName.isEmpty() ? null : this.actions.get(actionName);
            if (action != null) {
                actionContent = actionContent.contains(" ") ? actionContent.split(" ", 2)[1] : "";
                actionContent = TextUtil.raw(PlaceholderUtil.setPlaceholders(actionContent, (Audience)player));
                action.execute(this.plugin, player, (String)actionContent);
            }
        });
    }
}

