/*
 * Decompiled with CFR 0.152.
 */
package team.devblook.akropolis.libs.scoreboardlibrary.implementation.player;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.jetbrains.annotations.NotNull;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.ScoreboardLibraryImpl;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.objective.ObjectiveManagerImpl;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.objective.ObjectiveManagerTask;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.player.ScoreboardLibraryPlayer;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.sidebar.AbstractSidebar;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.sidebar.PlayerDependantLocaleSidebar;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.sidebar.SidebarTask;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.team.TeamManagerImpl;
import team.devblook.akropolis.libs.scoreboardlibrary.implementation.team.TeamManagerTask;

public class LocaleListener
implements Listener {
    private final ScoreboardLibraryImpl scoreboardLibrary;

    public LocaleListener(@NotNull ScoreboardLibraryImpl scoreboardLibrary) {
        this.scoreboardLibrary = scoreboardLibrary;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerLocaleChanged(PlayerLocaleChangeEvent event) {
        Player player = event.getPlayer();
        this.scoreboardLibrary.taskScheduler().runNextTick(() -> {
            ScoreboardLibraryPlayer slPlayer = this.scoreboardLibrary.getPlayer(player);
            if (slPlayer != null) {
                AbstractSidebar sidebar;
                ObjectiveManagerImpl objectiveManager;
                TeamManagerImpl teamManager = slPlayer.teamManagerQueue().current();
                if (teamManager != null) {
                    teamManager.taskQueue().add(new TeamManagerTask.ReloadPlayer(player));
                }
                if ((objectiveManager = slPlayer.objectiveManagerQueue().current()) != null) {
                    objectiveManager.taskQueue().add(new ObjectiveManagerTask.ReloadPlayer(player));
                }
                if ((sidebar = slPlayer.sidebarQueue().current()) instanceof PlayerDependantLocaleSidebar) {
                    sidebar.taskQueue().add(new SidebarTask.ReloadPlayer(player));
                }
            }
        });
    }
}

