/*
 * Decompiled with CFR 0.152.
 */
package team.devblook.akropolis.libs.scoreboardlibrary.api.noop;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.devblook.akropolis.libs.scoreboardlibrary.api.noop.NoopScoreboardTeam;
import team.devblook.akropolis.libs.scoreboardlibrary.api.noop.NoopTeamDisplay;
import team.devblook.akropolis.libs.scoreboardlibrary.api.team.ScoreboardTeam;
import team.devblook.akropolis.libs.scoreboardlibrary.api.team.TeamDisplay;
import team.devblook.akropolis.libs.scoreboardlibrary.api.team.TeamManager;

class NoopTeamManager
implements TeamManager {
    private final Set<Player> players = new HashSet<Player>();
    private final Map<String, NoopScoreboardTeam> teams = new HashMap<String, NoopScoreboardTeam>();
    private boolean closed;

    NoopTeamManager() {
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    @Override
    @NotNull
    public Collection<Player> players() {
        return this.closed ? Collections.emptySet() : Collections.unmodifiableSet(this.players);
    }

    @Override
    public boolean removePlayer(@NotNull Player player) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (!this.players.remove(player)) {
            return false;
        }
        for (NoopScoreboardTeam team : this.teams.values()) {
            team.displayMap().remove(player);
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<ScoreboardTeam> teams() {
        return this.closed ? Collections.emptySet() : Collections.unmodifiableCollection(this.teams.values());
    }

    @Override
    @Nullable
    public ScoreboardTeam team(@NotNull String name) {
        return this.teams.get(name.toLowerCase());
    }

    @Override
    public boolean teamExists(@NotNull String name) {
        return this.teams.containsKey(name.toLowerCase());
    }

    @Override
    @NotNull
    public ScoreboardTeam createIfAbsent(@NotNull String name, @Nullable BiFunction<Player, ScoreboardTeam, TeamDisplay> teamDisplayFunction) {
        Preconditions.checkNotNull((Object)name);
        this.checkClosed();
        name = name.toLowerCase();
        NoopScoreboardTeam team = this.teams.get(name);
        if (team != null) {
            return team;
        }
        team = new NoopScoreboardTeam(this, name);
        for (Player player : this.players) {
            NoopTeamDisplay teamDisplay = teamDisplayFunction == null ? team.defaultDisplay() : teamDisplayFunction.apply(player, team);
            this.validateTeamDisplay(team, teamDisplay);
            team.displayMap().put(player, teamDisplay);
        }
        return team;
    }

    @Override
    public boolean removeTeam(@NotNull String name) {
        Preconditions.checkNotNull((Object)name);
        this.checkClosed();
        return this.teams.remove(name.toLowerCase()) != null;
    }

    @Override
    public void removeTeam(@NotNull ScoreboardTeam team) {
        Preconditions.checkNotNull((Object)team);
        Preconditions.checkArgument((team.teamManager() == this ? 1 : 0) != 0);
        this.checkClosed();
        this.teams.remove(team.name(), (NoopScoreboardTeam)team);
    }

    @Override
    public boolean addPlayer(@NotNull Player player, @Nullable Function<ScoreboardTeam, TeamDisplay> teamDisplayFunction) {
        Preconditions.checkNotNull((Object)player);
        this.checkClosed();
        if (!this.players.add(player)) {
            return false;
        }
        for (NoopScoreboardTeam team : this.teams.values()) {
            NoopTeamDisplay teamDisplay = teamDisplayFunction == null ? team.defaultDisplay() : teamDisplayFunction.apply(team);
            this.validateTeamDisplay(team, teamDisplay);
            team.displayMap().put(player, teamDisplay);
        }
        return true;
    }

    private void validateTeamDisplay(@NotNull ScoreboardTeam team, @Nullable TeamDisplay teamDisplay) {
        if (teamDisplay == null || teamDisplay.team() != team) {
            throw new IllegalArgumentException("invalid TeamDisplay");
        }
        if (!(teamDisplay instanceof NoopTeamDisplay)) {
            throw new IllegalArgumentException("must be TeamDisplayImpl");
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("NoopTeamManager is closed");
        }
    }
}

