/*
 * Decompiled with CFR 0.152.
 */
package team.devblook.akropolis.libs.scoreboardlibrary.api.noop;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import team.devblook.akropolis.libs.scoreboardlibrary.api.ScoreboardLibrary;
import team.devblook.akropolis.libs.scoreboardlibrary.api.noop.NoopObjectiveManager;
import team.devblook.akropolis.libs.scoreboardlibrary.api.noop.NoopSidebar;
import team.devblook.akropolis.libs.scoreboardlibrary.api.noop.NoopTeamManager;
import team.devblook.akropolis.libs.scoreboardlibrary.api.objective.ObjectiveManager;
import team.devblook.akropolis.libs.scoreboardlibrary.api.sidebar.Sidebar;
import team.devblook.akropolis.libs.scoreboardlibrary.api.team.TeamManager;

public final class NoopScoreboardLibrary
implements ScoreboardLibrary {
    private boolean closed = false;

    @Override
    @NotNull
    public Sidebar createSidebar(@Range(from=1L, to=0x7FFFFFFFL) int maxLines, @Nullable Locale locale, @NotNull String objectiveName) {
        this.checkClosed();
        return new NoopSidebar(maxLines, objectiveName, locale);
    }

    @Override
    @NotNull
    public TeamManager createTeamManager() {
        this.checkClosed();
        return new NoopTeamManager();
    }

    @Override
    @NotNull
    public ObjectiveManager createObjectiveManager() {
        this.checkClosed();
        return new NoopObjectiveManager();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("NoopScoreboardLibrary is closed");
        }
    }
}

