/*
 * Decompiled with CFR 0.152.
 */
package team.devblook.akropolis.libs.scoreboardlibrary.api;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.apache.commons.lang.RandomStringUtils;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import team.devblook.akropolis.libs.scoreboardlibrary.api.exception.NoPacketAdapterAvailableException;
import team.devblook.akropolis.libs.scoreboardlibrary.api.objective.ObjectiveManager;
import team.devblook.akropolis.libs.scoreboardlibrary.api.sidebar.Sidebar;
import team.devblook.akropolis.libs.scoreboardlibrary.api.team.TeamManager;

@ApiStatus.NonExtendable
public interface ScoreboardLibrary {
    @NotNull
    public static ScoreboardLibrary loadScoreboardLibrary(@NotNull Plugin plugin) throws NoPacketAdapterAvailableException {
        Class<?> implClass;
        try {
            implClass = Class.forName("team.devblook.akropolis.libs.scoreboardlibrary.implementation.ScoreboardLibraryImpl");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("scoreboard-library implementation is not shaded into the classpath");
        }
        try {
            return (ScoreboardLibrary)implClass.getDeclaredConstructor(Plugin.class).newInstance(plugin);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Throwable targetException;
            if (e instanceof InvocationTargetException && (targetException = ((InvocationTargetException)e).getTargetException()) instanceof NoPacketAdapterAvailableException) {
                throw (NoPacketAdapterAvailableException)targetException;
            }
            throw new RuntimeException("failed to load scoreboard-library implementation", e);
        }
    }

    @NotNull
    default public Sidebar createSidebar() {
        return this.createSidebar(15);
    }

    @NotNull
    default public Sidebar createSidebar(@Range(from=1L, to=0x7FFFFFFFL) int maxLines) {
        return this.createSidebar(maxLines, null);
    }

    @NotNull
    default public Sidebar createSidebar(@Range(from=1L, to=0x7FFFFFFFL) int maxLines, @Nullable Locale locale) {
        return this.createSidebar(maxLines, locale, RandomStringUtils.randomAlphanumeric((int)16));
    }

    @NotNull
    public Sidebar createSidebar(@Range(from=1L, to=0x7FFFFFFFL) int var1, @Nullable Locale var2, @NotNull String var3);

    @NotNull
    public TeamManager createTeamManager();

    @NotNull
    public ObjectiveManager createObjectiveManager();

    public void close();

    public boolean closed();
}

