/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.visual.tablist;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import me.zetastormy.akropolis.module.modules.visual.tablist.TablistHelper;
import me.zetastormy.akropolis.module.modules.visual.tablist.TablistUpdateTask;
import me.zetastormy.akropolis.util.text.PlaceholderUtil;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class TablistManager
extends Module
implements LifeCycle {
    private List<UUID> players;
    private int tablistTask;
    private String header;
    private String footer;

    public TablistManager(AkropolisPlugin plugin) {
        super(plugin, ModuleType.TABLIST);
    }

    @Override
    public void onEnable() {
        this.players = new ArrayList<UUID>();
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.header = String.join((CharSequence)"\n", config.getStringList("tablist.header"));
        this.footer = String.join((CharSequence)"\n", config.getStringList("tablist.footer"));
        if (config.getBoolean("tablist.refresh.enabled")) {
            this.tablistTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.getPlugin(), (Runnable)new TablistUpdateTask(this), 0L, config.getLong("tablist.refresh.rate"));
        }
        this.getPlugin().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.getPlugin(), () -> Bukkit.getOnlinePlayers().stream().filter(player -> !this.inDisabledWorld(player.getLocation())).forEach(this::createTablist), 20L);
    }

    @Override
    public void onDisable() {
        Bukkit.getScheduler().cancelTask(this.tablistTask);
        Bukkit.getOnlinePlayers().forEach(this::removeTablist);
    }

    public void createTablist(Player player) {
        UUID uuid = player.getUniqueId();
        this.players.add(uuid);
        this.updateTablist(uuid);
    }

    public boolean updateTablist(UUID uuid) {
        if (!this.players.contains(uuid)) {
            return false;
        }
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return false;
        }
        TablistHelper.sendTabList(player, PlaceholderUtil.setPlaceholders(this.header, (Audience)player), PlaceholderUtil.setPlaceholders(this.footer, (Audience)player));
        return true;
    }

    public void removeTablist(Player player) {
        if (this.players.contains(player.getUniqueId())) {
            this.players.remove(player.getUniqueId());
            TablistHelper.sendTabList(player, null, null);
        }
    }

    public List<UUID> getPlayers() {
        return this.players;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.inDisabledWorld(player.getLocation())) {
            this.createTablist(player);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.removeTablist(event.getPlayer());
    }

    @EventHandler
    public void onWorldChange(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        World fromWorld = event.getFrom().getWorld();
        World toWorld = event.getTo().getWorld();
        if (toWorld == null) {
            return;
        }
        if (fromWorld == toWorld) {
            return;
        }
        if (this.inDisabledWorld(toWorld) && this.players.contains(player.getUniqueId())) {
            this.removeTablist(player);
            return;
        }
        this.createTablist(player);
    }
}

