/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.visual.bossbar;

import com.cryptomorin.xseries.XSound;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import me.zetastormy.akropolis.util.text.PlaceholderUtil;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class BossBarBroadcast
extends Module
implements Runnable,
LifeCycle {
    private Map<Integer, String> broadcasts;
    private BossBar broadcastBar;
    private int broadcastTask = 0;
    private int count = 0;
    private int size = 0;
    private Sound sound;
    private double volume;
    private double pitch;

    public BossBarBroadcast(AkropolisPlugin plugin) {
        super(plugin, ModuleType.BOSS_BAR_BROADCAST);
    }

    @Override
    public void onEnable() {
        String soundValue;
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.broadcasts = new HashMap<Integer, String>();
        int announcementsCount = 0;
        ConfigurationSection bossBarSettings = config.getConfigurationSection("boss_bar_announcements");
        if (bossBarSettings == null) {
            this.getPlugin().getLogger().info("Skipping boss bar broadcast, configuration section is missing!");
            return;
        }
        List announcements = bossBarSettings.getStringList("announcements");
        if (announcements.isEmpty()) {
            this.getPlugin().getLogger().severe("Boss bar announcements are missing in the configuration!");
            return;
        }
        for (String announcement : announcements) {
            this.broadcasts.put(announcementsCount, announcement);
            ++announcementsCount;
        }
        if (bossBarSettings.getBoolean("sound.enabled") && (soundValue = bossBarSettings.getString("sound.value")) != null) {
            XSound.of((String)soundValue).ifPresent(s -> {
                this.sound = (Sound)s.get();
            });
            this.volume = bossBarSettings.getDouble("sound.volume");
            this.pitch = bossBarSettings.getDouble("sound.pitch");
        }
        BossBar.Overlay overlayType = BossBar.Overlay.PROGRESS;
        try {
            overlayType = BossBar.Overlay.valueOf((String)bossBarSettings.getString("overlay.type", "PROGRESS"));
        }
        catch (IllegalArgumentException e) {
            this.getPlugin().getLogger().warning("An invalid overlay type has been found in the boss bar module, the default type 'PROGRESS' will be used!");
        }
        double overlayProgress = bossBarSettings.getDouble("overlay.progress", 1.0);
        if (overlayProgress > 1.0 || overlayProgress < 0.0) {
            this.getPlugin().getLogger().warning("An invalid overlay progress has been found in the boss bar module, the default progress '1.0' will be used!");
            overlayProgress = 1.0;
        }
        this.size = this.broadcasts.size();
        if (this.size > 0) {
            Component firstBroadcast = PlaceholderUtil.setPlaceholders(this.broadcasts.get(0), null);
            this.broadcastBar = BossBar.bossBar((Component)firstBroadcast, (float)((float)overlayProgress), (BossBar.Color)BossBar.Color.BLUE, (BossBar.Overlay)overlayType);
            ++this.count;
            Bukkit.getOnlinePlayers().forEach(p -> {
                if (!this.inDisabledWorld(p.getLocation())) {
                    p.showBossBar(this.broadcastBar);
                }
            });
            this.broadcastTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.getPlugin(), (Runnable)this, 60L, bossBarSettings.getLong("delay") * 20L);
        }
    }

    @Override
    public void onDisable() {
        Bukkit.getScheduler().cancelTask(this.broadcastTask);
        Bukkit.getOnlinePlayers().forEach(player -> player.activeBossBars().forEach(arg_0 -> ((Player)player).hideBossBar(arg_0)));
    }

    @Override
    public void run() {
        if (this.count == this.size) {
            this.count = 0;
        }
        if (this.count >= this.size) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.inDisabledWorld(player.getLocation())) {
                player.activeBossBars().forEach(b -> {
                    if (b.equals((Object)this.broadcastBar)) {
                        player.hideBossBar(this.broadcastBar);
                    }
                });
                continue;
            }
            Component parsedMessage = PlaceholderUtil.setPlaceholders(this.broadcasts.get(this.count), null);
            this.broadcastBar.name(parsedMessage);
            if (this.sound == null) continue;
            player.playSound(player.getLocation(), this.sound, (float)this.volume, (float)this.pitch);
        }
        ++this.count;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        player.showBossBar(this.broadcastBar);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWorldChange(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        World fromWorld = event.getFrom().getWorld();
        World toWorld = event.getTo().getWorld();
        if (toWorld == null) {
            return;
        }
        if (fromWorld == toWorld) {
            return;
        }
        if (this.inDisabledWorld(toWorld)) {
            player.hideBossBar(this.broadcastBar);
            return;
        }
        player.showBossBar(this.broadcastBar);
    }
}

