/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.player;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.config.Message;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PlayerVanish
extends Module
implements LifeCycle {
    private List<UUID> vanished;

    public PlayerVanish(AkropolisPlugin plugin) {
        super(plugin, ModuleType.VANISH);
    }

    @Override
    public void onEnable() {
        this.vanished = new ArrayList<UUID>();
    }

    @Override
    public void onDisable() {
        this.vanished.clear();
    }

    public void toggleVanish(Player player) {
        if (this.isVanished(player)) {
            this.vanished.remove(player.getUniqueId());
            Bukkit.getOnlinePlayers().forEach(pl -> pl.showPlayer(player));
            Message.VANISH_DISABLE.send((Audience)player);
            player.removePotionEffect(PotionEffectType.NIGHT_VISION);
        } else {
            this.vanished.add(player.getUniqueId());
            Bukkit.getOnlinePlayers().forEach(pl -> pl.hidePlayer(player));
            Message.VANISH_ENABLE.send((Audience)player);
            player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, 1000000, 1));
        }
    }

    public boolean isVanished(Player player) {
        return this.vanished.contains(player.getUniqueId());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.vanished.forEach(hidden -> {
            Player playerHidden = Bukkit.getPlayer((UUID)hidden);
            if (playerHidden == null) {
                return;
            }
            event.getPlayer().hidePlayer(playerHidden);
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        player.removePotionEffect(PotionEffectType.NIGHT_VISION);
        this.vanished.remove(player.getUniqueId());
    }
}

