/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.player;

import java.util.List;
import java.util.UUID;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.Permissions;
import me.zetastormy.akropolis.config.ConfigType;
import me.zetastormy.akropolis.config.Message;
import me.zetastormy.akropolis.module.LifeCycle;
import me.zetastormy.akropolis.module.Module;
import me.zetastormy.akropolis.module.ModuleType;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;

public class DoubleJump
extends Module
implements LifeCycle {
    private long cooldownDelay;
    private double launch;
    private double launchY;
    private boolean onGround;
    private List<String> actions;

    public DoubleJump(AkropolisPlugin plugin) {
        super(plugin, ModuleType.DOUBLE_JUMP);
    }

    @Override
    public void onEnable() {
        FileConfiguration config = this.getConfig(ConfigType.SETTINGS);
        this.cooldownDelay = config.getLong("double_jump.cooldown", 0L);
        this.launch = config.getDouble("double_jump.launch_power", 1.3);
        this.launchY = config.getDouble("double_jump.launch_power_y", 1.2);
        this.onGround = config.getBoolean("double_jump.on_ground", true);
        this.actions = config.getStringList("double_jump.actions");
        if (this.launch > 4.0) {
            this.launch = 4.0;
        }
        if (this.launchY > 4.0) {
            this.launchY = 4.0;
        }
    }

    @EventHandler
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        Location playerLocation = player.getLocation();
        if (player.hasPermission(Permissions.DOUBLE_JUMP_BYPASS.getPermission()) || player.hasPermission(Permissions.COMMAND_FLIGHT.getPermission())) {
            return;
        }
        if (this.inDisabledWorld(playerLocation)) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (!event.isFlying()) {
            return;
        }
        if (this.onGround && player.getWorld().getBlockAt(playerLocation.subtract(0.0, 2.0, 0.0)).getType() == Material.AIR) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        UUID uuid = player.getUniqueId();
        if (!this.tryCooldown(uuid, "double_jump", this.cooldownDelay)) {
            Message.DOUBLE_JUMP_COOLDOWN.sendWithReplacement((Audience)player, "time", (Component)Component.text((long)this.getCooldown(uuid, "double_jump")));
            return;
        }
        player.setVelocity(playerLocation.getDirection().multiply(this.launch).setY(this.launchY));
        this.executeActions(player, this.actions);
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR) {
            player.setAllowFlight(!this.inDisabledWorld(player.getLocation()));
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR) {
            player.setAllowFlight(!this.inDisabledWorld(player.getLocation()));
        }
    }

    @EventHandler
    public void onGameModeChange(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        if (this.inDisabledWorld(player.getLocation())) {
            return;
        }
        GameMode newGameMode = event.getNewGameMode();
        if (newGameMode != GameMode.CREATIVE && newGameMode != GameMode.SPECTATOR) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.getPlugin(), () -> player.setAllowFlight(true), 1L);
        }
    }
}

