/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.hotbar.items;

import java.util.UUID;
import me.zetastormy.akropolis.module.ModuleType;
import me.zetastormy.akropolis.module.modules.hotbar.HotbarItem;
import me.zetastormy.akropolis.module.modules.hotbar.HotbarManager;
import me.zetastormy.akropolis.module.modules.player.FightModeManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;

public class FightMode
extends HotbarItem {
    private final FightModeManager fightModeManager = (FightModeManager)this.getPlugin().getModuleManager().getModule(ModuleType.FIGHT_MODE);

    public FightMode(HotbarManager hotbarManager, ItemStack item, int slot, String keyValue) {
        super(hotbarManager, item, slot, keyValue);
    }

    @Override
    protected void onInteract(Player player) {
    }

    @Override
    public void removeItem(Player player) {
        super.removeItem(player);
        this.fightModeManager.disableFightMode(player);
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        UUID playerUuid = player.getUniqueId();
        ItemStack newItem = player.getInventory().getItem(event.getNewSlot());
        if (this.fightModeManager.isInFightMode(playerUuid)) {
            if (this.fightModeManager.isValidItem(newItem)) {
                this.fightModeManager.cancelHoldTask(playerUuid);
            } else if (!this.fightModeManager.hasHoldTask(playerUuid)) {
                this.fightModeManager.startDeactivationTimer(player);
            }
            return;
        }
        if (this.fightModeManager.isValidItem(newItem)) {
            this.fightModeManager.cancelHoldTask(playerUuid);
            this.fightModeManager.startActivationTimer(player);
        } else {
            this.fightModeManager.cancelHoldTask(playerUuid);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.fightModeManager.disableFightMode(event.getPlayer());
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        this.fightModeManager.disableFightMode(event.getPlayer());
    }

    @EventHandler
    public void onRespawnEvent(PlayerRespawnEvent event) {
        this.fightModeManager.disableFightMode(event.getPlayer());
    }
}

