/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.hologram;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Nameable;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;

public class Hologram {
    private final List<ArmorStand> stands;
    private Location location;
    private final String name;

    public Hologram(String name, Location location) {
        this.name = name;
        this.location = location;
        this.stands = new ArrayList<ArmorStand>();
    }

    public void setLines(List<Component> lines) {
        this.remove();
        lines.forEach(this::addLine);
    }

    public void addLine(Component text) {
        World world = this.location.getWorld();
        if (world == null) {
            return;
        }
        ArmorStand stand = (ArmorStand)world.spawnEntity(this.location.clone().subtract(0.0, this.getHeight(), 0.0), EntityType.ARMOR_STAND);
        stand.setVisible(false);
        stand.setGravity(false);
        stand.setCustomNameVisible(true);
        stand.customName(text);
        stand.setCanPickupItems(false);
        this.stands.add(stand);
    }

    public void setLine(int line, Component text) {
        ArmorStand stand = this.stands.get(line - 1);
        stand.customName(text);
    }

    public Hologram removeLine(int line) {
        ArmorStand stand = this.stands.get(line - 1);
        stand.remove();
        this.stands.remove(line - 1);
        if (!this.refreshLines(line - 1)) {
            return null;
        }
        return this;
    }

    public boolean refreshLines(int line) {
        ArrayList<ArmorStand> standsTemp = new ArrayList<ArmorStand>();
        int count = 0;
        for (ArmorStand entry : this.stands) {
            if (count >= line) {
                standsTemp.add(entry);
            }
            ++count;
        }
        for (ArmorStand stand : standsTemp) {
            stand.teleportAsync(stand.getLocation().add(0.0, 0.25, 0.0));
        }
        return count >= 1;
    }

    public void setLocation(Location location) {
        this.location = location;
        this.setLines(this.stands.stream().map(Nameable::customName).collect(Collectors.toList()));
    }

    public boolean hasInvalidLine(int line) {
        return line - 1 >= this.stands.size() || line <= 0;
    }

    public void remove() {
        for (ArmorStand stand : this.stands) {
            stand.remove();
        }
        this.stands.clear();
    }

    public Location getLocation() {
        return this.location;
    }

    public List<ArmorStand> getStands() {
        return this.stands;
    }

    public String getName() {
        return this.name;
    }

    private double getHeight() {
        return (double)this.stands.size() * 0.25;
    }
}

