/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.module.modules.chat.groups;

import me.zetastormy.akropolis.module.modules.chat.groups.Emojis;
import me.zetastormy.akropolis.util.text.PlaceholderUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public class ChatGroup {
    private final String rawFormat;
    private final int priority;
    private final int cooldownTime;
    private final String cooldownMessage;
    private final Emojis emojis;
    private final String permission;

    public ChatGroup(String groupName, String rawFormat, int priority, int cooldownTime, String cooldownMessage, Emojis emojis) {
        this.rawFormat = rawFormat;
        this.priority = priority;
        this.cooldownTime = cooldownTime;
        this.cooldownMessage = cooldownMessage;
        this.emojis = emojis;
        this.permission = "akropolis.chat.group." + groupName;
    }

    public Component getFormat(Player player) {
        return PlaceholderUtil.setPlaceholders(this.rawFormat, (Audience)player);
    }

    public int getPriority() {
        return this.priority;
    }

    public int getCooldownTime() {
        return this.cooldownTime;
    }

    public Component getCooldownMessage() {
        return PlaceholderUtil.setPlaceholders(this.cooldownMessage, null);
    }

    public String parseEmojis(String message) {
        return this.emojis.parse(message);
    }

    public String getPermission() {
        return this.permission;
    }
}

