/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.command.commands.gamemode;

import java.util.List;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.Permissions;
import me.zetastormy.akropolis.command.InjectableCommand;
import me.zetastormy.akropolis.config.Message;
import me.zetastormy.akropolis.util.text.TextUtil;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CreativeCommand
extends InjectableCommand {
    public CreativeCommand(AkropolisPlugin plugin, List<String> aliases) {
        super((Plugin)plugin, "gmc", "Change to creative mode", "/gmc [player]", aliases);
    }

    @Override
    public void onCommand(CommandSender sender, String label, String[] args) {
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                Message.CONSOLE_NOT_ALLOWED.send((Audience)sender);
                return;
            }
            Player player = (Player)sender;
            if (!player.hasPermission(Permissions.COMMAND_GAMEMODE.getPermission())) {
                Message.NO_PERMISSION.send((Audience)player);
                return;
            }
            Message.GAMEMODE_CHANGE.sendWithReplacement((Audience)player, "gamemode", TextUtil.parse("CREATIVE"));
            player.setGameMode(GameMode.CREATIVE);
        } else if (args.length == 1) {
            if (!sender.hasPermission(Permissions.COMMAND_GAMEMODE_OTHERS.getPermission())) {
                Message.NO_PERMISSION.send((Audience)sender);
                return;
            }
            Player player = Bukkit.getPlayer((String)args[0]);
            if (player == null) {
                Message.INVALID_PLAYER.sendWithReplacement((Audience)sender, "player", TextUtil.parse(args[0]));
                return;
            }
            if (sender.getName().equals(player.getName())) {
                Message.GAMEMODE_CHANGE.sendWithReplacement((Audience)player, "gamemode", TextUtil.parse("CREATIVE"));
            } else {
                Message.GAMEMODE_CHANGE.sendWithReplacement((Audience)player, "gamemode", TextUtil.parse("CREATIVE"));
                sender.sendMessage(TextUtil.replace(TextUtil.replace(Message.GAMEMODE_CHANGE_OTHER.toComponent(), "player", player.name()), "gamemode", TextUtil.parse("CREATIVE")));
            }
            player.setGameMode(GameMode.CREATIVE);
        }
    }
}

