/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.command;

import java.util.List;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.command.InjectableCommand;
import me.zetastormy.akropolis.config.Message;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CustomCommand
extends InjectableCommand {
    private String permission;
    private final List<String> actions;

    public CustomCommand(Plugin plugin, String name, List<String> aliases, List<String> actions) {
        super(plugin, name, "A custom Akropolis command", aliases);
        this.actions = actions;
    }

    @Override
    protected void onCommand(CommandSender sender, String label, String[] args) {
        if (!(sender instanceof Player)) {
            Message.CONSOLE_NOT_ALLOWED.send((Audience)sender);
            return;
        }
        Player player = (Player)sender;
        if (this.permission != null && !sender.hasPermission(this.permission)) {
            Message.CUSTOM_COMMAND_NO_PERMISSION.send((Audience)sender);
            return;
        }
        AkropolisPlugin.getInstance().getActionManager().executeActions(player, this.actions);
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String getPermission() {
        return this.permission;
    }

    public List<String> getActions() {
        return this.actions;
    }
}

