/*
 * Decompiled with CFR 0.152.
 */
package me.zetastormy.akropolis.command;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.zetastormy.akropolis.AkropolisPlugin;
import me.zetastormy.akropolis.command.CustomCommand;
import me.zetastormy.akropolis.command.InjectableCommand;
import me.zetastormy.akropolis.command.commands.AkropolisCommand;
import me.zetastormy.akropolis.command.commands.ClearchatCommand;
import me.zetastormy.akropolis.command.commands.FlyCommand;
import me.zetastormy.akropolis.command.commands.LobbyCommand;
import me.zetastormy.akropolis.command.commands.LockchatCommand;
import me.zetastormy.akropolis.command.commands.SetLobbyCommand;
import me.zetastormy.akropolis.command.commands.VanishCommand;
import me.zetastormy.akropolis.command.commands.gamemode.AdventureCommand;
import me.zetastormy.akropolis.command.commands.gamemode.CreativeCommand;
import me.zetastormy.akropolis.command.commands.gamemode.GamemodeCommand;
import me.zetastormy.akropolis.command.commands.gamemode.SpectatorCommand;
import me.zetastormy.akropolis.command.commands.gamemode.SurvivalCommand;
import me.zetastormy.akropolis.config.ConfigType;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandManager {
    private final AkropolisPlugin plugin;
    private final Set<InjectableCommand> commands;
    private final List<CustomCommand> customCommands;
    private final CommandMap commandMap;
    private FileConfiguration config;

    public CommandManager(AkropolisPlugin plugin) {
        this.plugin = plugin;
        this.commands = new HashSet<InjectableCommand>();
        this.customCommands = new ArrayList<CustomCommand>();
        this.commandMap = Bukkit.getCommandMap();
    }

    public void reload() {
        this.config = this.plugin.getConfigManager().getFile(ConfigType.COMMANDS).get();
        this.commands.forEach(this::unregisterCommand);
        if (!this.commands.isEmpty()) {
            this.commands.clear();
        }
        this.registerCommand(new AkropolisCommand(this.plugin));
        ConfigurationSection commandsSection = this.config.getConfigurationSection("commands");
        if (commandsSection == null) {
            this.plugin.getLogger().severe("Commands settings configuration section is missing!");
            return;
        }
        for (String command : commandsSection.getKeys(false)) {
            if (!this.config.getBoolean("commands." + command + ".enabled")) continue;
            this.registerCommand(command, commandsSection.getStringList(command + ".aliases"));
        }
        this.reloadCustomCommands();
        Bukkit.getOnlinePlayers().forEach(Player::updateCommands);
    }

    public void reloadCustomCommands() {
        this.customCommands.forEach(this::unregisterCommand);
        if (!this.customCommands.isEmpty()) {
            this.customCommands.clear();
        }
        if (!this.config.isSet("custom_commands")) {
            return;
        }
        ConfigurationSection customCommandsSection = this.config.getConfigurationSection("custom_commands");
        if (customCommandsSection == null) {
            this.plugin.getLogger().info("Skipping custom commands registration, configuration section is missing!");
            return;
        }
        for (String entry : customCommandsSection.getKeys(false)) {
            List actions = customCommandsSection.getStringList(entry + ".actions");
            ArrayList<String> aliases = new ArrayList();
            if (customCommandsSection.contains(entry + ".aliases")) {
                aliases = this.config.getStringList("custom_commands." + entry + ".aliases");
            }
            CustomCommand customCommand = new CustomCommand((Plugin)this.plugin, entry, aliases, (List<String>)actions);
            if (customCommandsSection.contains(entry + ".permission")) {
                customCommand.setPermission(this.config.getString("custom_commands." + entry + ".permission"));
            }
            this.registerCommand(customCommand);
        }
    }

    private void registerCommand(String cmd, List<String> aliases) {
        switch (cmd.toUpperCase()) {
            case "GAMEMODE": {
                this.registerCommand(new GamemodeCommand(this.plugin, aliases));
                break;
            }
            case "GMS": {
                this.registerCommand(new SurvivalCommand(this.plugin, aliases));
                break;
            }
            case "GMC": {
                this.registerCommand(new CreativeCommand(this.plugin, aliases));
                break;
            }
            case "GMA": {
                this.registerCommand(new AdventureCommand(this.plugin, aliases));
                break;
            }
            case "GMSP": {
                this.registerCommand(new SpectatorCommand(this.plugin, aliases));
                break;
            }
            case "CLEARCHAT": {
                this.registerCommand(new ClearchatCommand(this.plugin, aliases));
                break;
            }
            case "FLY": {
                this.registerCommand(new FlyCommand(this.plugin, aliases));
                break;
            }
            case "LOCKCHAT": {
                this.registerCommand(new LockchatCommand(this.plugin, aliases));
                break;
            }
            case "SETLOBBY": {
                this.registerCommand(new SetLobbyCommand(this.plugin, aliases));
                break;
            }
            case "LOBBY": {
                this.registerCommand(new LobbyCommand(this.plugin, aliases));
                break;
            }
            case "VANISH": {
                this.registerCommand(new VanishCommand(this.plugin, aliases));
                break;
            }
        }
    }

    private void registerCommand(InjectableCommand command) {
        try {
            this.commandMap.register("akropolis", (Command)command);
            this.commands.add(command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void unregisterCommand(InjectableCommand command) {
        try {
            command.getAliases().forEach(a -> this.commandMap.getKnownCommands().remove(a));
            this.commandMap.getKnownCommands().remove(command.getName());
            this.commandMap.getKnownCommands().remove("akropolis:" + command.getName());
            command.unregister(this.commandMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<CustomCommand> getCustomCommands() {
        return this.customCommands;
    }
}

