/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.storage;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import me.yleoft.zHomes.configuration.languages.LanguageBuilder;
import me.yleoft.zHomes.libs.zAPI.location.LocationHandler;
import me.yleoft.zHomes.libs.zAPI.player.PlayerHandler;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import me.yleoft.zHomes.storage.DatabaseConnection;
import me.yleoft.zHomes.storage.database_type;
import me.yleoft.zHomes.zHomes;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DatabaseEditor
extends DatabaseConnection {
    public static void createTable(String table, String coluns) {
        try (Connection con = DatabaseEditor.getConnection();
             PreparedStatement ps = con.prepareStatement("CREATE TABLE IF NOT EXISTS " + table + coluns);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            zHomes.getInstance().getLoggerInstance().error("Error creating table: " + table, e);
        }
    }

    public static void addNameColumn() {
        boolean justCreated = false;
        try (Connection con = DatabaseEditor.getConnection();
             PreparedStatement ps = con.prepareStatement("ALTER TABLE " + DatabaseEditor.databaseTable() + " ADD COLUMN NAME VARCHAR(45)");){
            ps.executeUpdate();
            justCreated = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (!justCreated) {
            return;
        }
        zAPI.getScheduler().runAsync(task -> {
            zHomes.getInstance().getLoggerInstance().info("NAME column added to database, backfilling player names...");
            ArrayList<String> uuids = new ArrayList<String>();
            try (Connection con = DatabaseEditor.getConnection();
                 PreparedStatement ps = con.prepareStatement("SELECT DISTINCT UUID FROM " + DatabaseEditor.databaseTable());
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    uuids.add(rs.getString("UUID"));
                }
            }
            catch (SQLException e) {
                zHomes.getInstance().getLoggerInstance().error("Error fetching UUIDs for name backfill", e);
                return;
            }
            int success = 0;
            int failed = 0;
            for (String uuidStr : uuids) {
                try {
                    UUID uuid = UUID.fromString(uuidStr);
                    OfflinePlayer p = PlayerHandler.getOfflinePlayer(uuid);
                    if (p.getName() != null) {
                        Connection con = DatabaseEditor.getConnection();
                        try {
                            PreparedStatement ps = con.prepareStatement("UPDATE " + DatabaseEditor.databaseTable() + " SET NAME=? WHERE UUID=?");
                            try {
                                ps.setString(1, p.getName());
                                ps.setString(2, uuidStr);
                                ps.executeUpdate();
                                ++success;
                                continue;
                            }
                            finally {
                                if (ps != null) {
                                    ps.close();
                                }
                                continue;
                            }
                        }
                        finally {
                            if (con == null) continue;
                            con.close();
                            continue;
                        }
                    }
                    ++failed;
                }
                catch (Exception e) {
                    ++failed;
                }
            }
            zHomes.getInstance().getLoggerInstance().info("Database Name backfill complete: " + success + " resolved, " + failed + " unresolved (will populate on next players login).");
        });
    }

    public static String databaseTable() {
        return zHomes.getConfigYAML().getDatabaseTable();
    }

    public static void setHome(OfflinePlayer p, String home, String location) {
        block25: {
            try (Connection con = DatabaseEditor.getConnection();){
                String uuid = p.getUniqueId().toString();
                String name = p.getName();
                if (DatabaseEditor.isInTable(p, home)) {
                    try (PreparedStatement ps = con.prepareStatement("UPDATE " + DatabaseEditor.databaseTable() + " SET LOCATION=?, NAME=? WHERE UUID=? AND LOWER(HOME)=LOWER(?)");){
                        ps.setString(1, location);
                        ps.setString(2, name);
                        ps.setString(3, uuid);
                        ps.setString(4, home);
                        ps.executeUpdate();
                        break block25;
                    }
                }
                String query = switch (type) {
                    case database_type.SQLITE -> "INSERT OR IGNORE INTO " + DatabaseEditor.databaseTable() + " (UUID,NAME,HOME,LOCATION) VALUES (?,?,?,?)";
                    case database_type.H2 -> "MERGE INTO " + DatabaseEditor.databaseTable() + " (UUID, NAME, HOME, LOCATION) KEY(UUID, HOME) VALUES (?, ?, ?, ?)";
                    default -> "INSERT IGNORE INTO " + DatabaseEditor.databaseTable() + " (UUID,NAME,HOME,LOCATION) VALUES (?,?,?,?)";
                };
                try (PreparedStatement ps = con.prepareStatement(query);){
                    ps.setString(1, uuid);
                    ps.setString(2, name);
                    ps.setString(3, home);
                    ps.setString(4, location);
                    ps.executeUpdate();
                }
            }
            catch (SQLException e) {
                zHomes.getInstance().getLoggerInstance().error("Error setting home for player: " + p.getName(), e);
            }
        }
    }

    public static void deleteHome(OfflinePlayer p, String home) {
        try (Connection con = DatabaseEditor.getConnection();
             PreparedStatement ps2 = con.prepareStatement("DELETE FROM " + DatabaseEditor.databaseTable() + " WHERE UUID=? AND LOWER(HOME)=LOWER(?)");){
            String uuid = p.getUniqueId().toString();
            ps2.setString(1, uuid);
            ps2.setString(2, home);
            ps2.executeUpdate();
        }
        catch (SQLException e) {
            zHomes.getInstance().getLoggerInstance().error("Error deleting home for player: " + p.getName(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHome(OfflinePlayer p, String home) {
        try (Connection con = DatabaseEditor.getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT LOCATION from " + DatabaseEditor.databaseTable() + " WHERE UUID=? AND LOWER(HOME)=LOWER(?)");){
            String uuid = p.getUniqueId().toString();
            ps.setString(1, uuid);
            ps.setString(2, home);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return "";
                String string = rs.getString("LOCATION");
                return string;
            }
        }
        catch (SQLException e) {
            zHomes.getInstance().getLoggerInstance().error("Error getting homes for player: " + p.getName(), e);
        }
        return "";
    }

    public static List<String> getHomes(OfflinePlayer p) {
        ArrayList<String> list = new ArrayList<String>();
        if (p == null) {
            return list;
        }
        try (Connection con = DatabaseEditor.getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM " + DatabaseEditor.databaseTable() + " WHERE UUID=?");){
            ps.setString(1, p.getUniqueId().toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(rs.getString("HOME"));
                }
            }
        }
        catch (SQLException e) {
            zHomes.getInstance().getLoggerInstance().error("Error getting homes for player: " + p.getName(), e);
        }
        return list;
    }

    public static void updatePlayerName(OfflinePlayer p) {
        if (p.getName() == null) {
            return;
        }
        try (Connection con = DatabaseEditor.getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE " + DatabaseEditor.databaseTable() + " SET NAME=? WHERE UUID=?");){
            ps.setString(1, p.getName());
            ps.setString(2, p.getUniqueId().toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            zHomes.getInstance().getLoggerInstance().error("Error updating name for: " + p.getName(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UUID getUUIDByName(String name) {
        try (Connection con = DatabaseEditor.getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT UUID FROM " + DatabaseEditor.databaseTable() + " WHERE LOWER(NAME)=LOWER(?) LIMIT 1");){
            ps.setString(1, name);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                UUID uUID = UUID.fromString(rs.getString("UUID"));
                return uUID;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static HashMap<OfflinePlayer, List<String>> getNearHomes(Location loc, double radius) {
        HashMap<OfflinePlayer, List<String>> result = new HashMap<OfflinePlayer, List<String>>();
        if (loc == null || loc.getWorld() == null) {
            return result;
        }
        double radiusSq = radius * radius;
        try (Connection con = DatabaseEditor.getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT UUID, HOME, LOCATION FROM " + DatabaseEditor.databaseTable());
             ResultSet rs = ps.executeQuery();){
            World world = loc.getWorld();
            while (rs.next()) {
                String uuid = rs.getString("UUID");
                String home = rs.getString("HOME");
                String locStr = rs.getString("LOCATION");
                Location homeLoc = LocationHandler.deserialize(locStr);
                if (!Objects.equals(homeLoc.getWorld(), world) || !(homeLoc.distanceSquared(loc) <= radiusSq)) continue;
                OfflinePlayer owner = PlayerHandler.getOfflinePlayer(UUID.fromString(uuid));
                result.computeIfAbsent(owner, k -> new ArrayList()).add(home);
            }
        }
        catch (SQLException e) {
            zHomes.getInstance().getLoggerInstance().error("Error getting near homes", e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static long getTotalHomes() {
        long count = 0L;
        try (Connection con = DatabaseEditor.getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT COUNT(*) AS total FROM " + DatabaseEditor.databaseTable());
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                count = rs.getLong("total");
            }
        }
        catch (SQLException e) {
            zHomes.getInstance().getLoggerInstance().error("Error getting total homes", e);
        }
        return count;
    }

    public static long getTotalUsers() {
        long count = 0L;
        try (Connection con = DatabaseEditor.getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT COUNT(DISTINCT UUID) AS total FROM " + DatabaseEditor.databaseTable());
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                count = rs.getLong("total");
            }
        }
        catch (SQLException e) {
            zHomes.getInstance().getLoggerInstance().error("Error getting total users", e);
        }
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int purgeHomes(PurgeFilter filter) {
        if (filter == null) {
            return 0;
        }
        try (Connection con = DatabaseEditor.getConnection();){
            if (filter.hasInMemoryFilters()) {
                int n2 = DatabaseEditor.purgeWithInMemoryFilter(con, filter);
                return n2;
            }
            int n = DatabaseEditor.purgeWithSqlFilter(con, filter);
            return n;
        }
        catch (SQLException e) {
            zHomes.getInstance().getLoggerInstance().error("Error purging homes with filter", e);
            return -1;
        }
    }

    private static int purgeWithSqlFilter(Connection con, PurgeFilter filter) throws SQLException {
        StringBuilder sql = new StringBuilder("DELETE FROM ").append(DatabaseEditor.databaseTable()).append(" WHERE 1=1");
        ArrayList<Object> params = new ArrayList<Object>();
        if (filter.playerUuid != null) {
            sql.append(" AND UUID=?");
            params.add(filter.playerUuid.toString());
        }
        if (filter.homeStartsWith != null && !filter.homeStartsWith.isEmpty()) {
            sql.append(" AND LOWER(HOME) LIKE LOWER(?)");
            params.add(filter.homeStartsWith + "%");
        }
        if (filter.homeEndsWith != null && !filter.homeEndsWith.isEmpty()) {
            sql.append(" AND LOWER(HOME) LIKE LOWER(?)");
            params.add("%" + filter.homeEndsWith);
        }
        try (PreparedStatement ps = con.prepareStatement(sql.toString());){
            for (int i = 0; i < params.size(); ++i) {
                ps.setString(i + 1, (String)params.get(i));
            }
            int deleted = ps.executeUpdate();
            zHomes.getInstance().getLoggerInstance().info("Purged " + deleted + " homes with SQL filter");
            int n = deleted;
            return n;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int purgeWithInMemoryFilter(Connection con, PurgeFilter filter) throws SQLException {
        ArrayList<CallSite> toDelete;
        block30: {
            toDelete = new ArrayList<CallSite>();
            StringBuilder sql = new StringBuilder("SELECT UUID, HOME, LOCATION FROM ").append(DatabaseEditor.databaseTable()).append(" WHERE 1=1");
            ArrayList<Object> params = new ArrayList<Object>();
            if (filter.playerUuid != null) {
                sql.append(" AND UUID=?");
                params.add(filter.playerUuid.toString());
            }
            if (filter.homeStartsWith != null && !filter.homeStartsWith.isEmpty()) {
                sql.append(" AND LOWER(HOME) LIKE LOWER(?)");
                params.add(filter.homeStartsWith + "%");
            }
            if (filter.homeEndsWith != null && !filter.homeEndsWith.isEmpty()) {
                sql.append(" AND LOWER(HOME) LIKE LOWER(?)");
                params.add("%" + filter.homeEndsWith);
            }
            try (PreparedStatement ps = con.prepareStatement(sql.toString());){
                for (int i = 0; i < params.size(); ++i) {
                    ps.setString(i + 1, (String)params.get(i));
                }
                ResultSet rs = ps.executeQuery();
                block18: while (true) {
                    while (rs.next()) {
                        String string = rs.getString("UUID");
                        String homeName = rs.getString("HOME");
                        String locationStr = rs.getString("LOCATION");
                        try {
                            UUID uuid = UUID.fromString(string);
                            if (filter.customFilter != null && !filter.matchesCustomFilter(uuid, homeName)) continue;
                            if (filter.worldName != null) {
                                Location loc = LocationHandler.deserialize(locationStr);
                                if (loc == null || loc.getWorld() == null) continue block18;
                                if (!loc.getWorld().getName().equalsIgnoreCase(filter.worldName)) continue;
                            }
                            toDelete.add((CallSite)((Object)(string + ":" + homeName)));
                            continue block18;
                        }
                        catch (Exception exception) {
                        }
                    }
                    break block30;
                    {
                        continue block18;
                        break;
                    }
                    break;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
        }
        if (toDelete.isEmpty()) {
            return 0;
        }
        try (PreparedStatement deletePs = con.prepareStatement("DELETE FROM " + DatabaseEditor.databaseTable() + " WHERE UUID=? AND HOME=?");){
            void var7_16;
            con.setAutoCommit(false);
            for (String string : toDelete) {
                String[] parts = string.split(":", 2);
                deletePs.setString(1, parts[0]);
                deletePs.setString(2, parts[1]);
                deletePs.addBatch();
            }
            int[] results = deletePs.executeBatch();
            con.commit();
            con.setAutoCommit(true);
            boolean bl = false;
            for (int result : results) {
                var7_16 += Math.max(0, result);
            }
            zHomes.getInstance().getLoggerInstance().info("Purged " + (int)var7_16 + " homes with in-memory filter");
            void var8_20 = var7_16;
            return (int)var8_20;
        }
    }

    public static boolean isInTable(OfflinePlayer p, String home) {
        try {
            String uuid = p.getUniqueId().toString();
            if (DatabaseEditor.existsTableColumnValueDoubleLower(DatabaseEditor.databaseTable(), "UUID", uuid, "HOME", home)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static File exportDatabase(CommandSender sender) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Sound getEntityLevelUP() {
        try {
            return Sound.ENTITY_PLAYER_LEVELUP;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static int importDatabase(File gzJsonFile, CommandSender sender) {
        List entries;
        if (gzJsonFile == null || !gzJsonFile.exists()) {
            zHomes.getInstance().getLoggerInstance().error("Import file does not exist: " + (gzJsonFile == null ? "null" : gzJsonFile.getAbsolutePath()));
            return -1;
        }
        try (GZIPInputStream gis = new GZIPInputStream(Files.newInputStream(gzJsonFile.toPath(), new OpenOption[0]));
             InputStreamReader reader = new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8);){
            Gson gson = new Gson();
            entries = (List)gson.fromJson((Reader)reader, new TypeToken<List<ExportEntry>>(){}.getType());
            if (entries == null) {
                entries = Collections.emptyList();
            }
        }
        catch (Exception e) {
            zHomes.getInstance().getLoggerInstance().error("Error reading import file: " + gzJsonFile.getAbsolutePath(), e);
            if (sender != null) {
                LanguageBuilder.sendMessage(sender, "<red>Failed to import database. Check console for details.");
            }
            return -1;
        }
        if (entries.isEmpty()) {
            zHomes.getInstance().getLoggerInstance().info("Import file contained no entries: " + gzJsonFile.getAbsolutePath());
            if (sender != null) {
                LanguageBuilder.sendMessage(sender, "<red>Import file contained no entries.");
            }
            return 0;
        }
        String insertQuery = switch (type) {
            case database_type.H2 -> "MERGE INTO " + DatabaseEditor.databaseTable() + " (UUID, NAME, HOME, LOCATION) KEY(UUID, HOME) VALUES (?, ?, ?, ?)";
            case database_type.SQLITE -> "INSERT OR REPLACE INTO " + DatabaseEditor.databaseTable() + " (UUID, NAME, HOME, LOCATION) VALUES (?, ?, ?, ?)";
            default -> "INSERT INTO " + DatabaseEditor.databaseTable() + " (UUID, NAME, HOME, LOCATION) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE LOCATION = VALUES(LOCATION), NAME = VALUES(NAME)";
        };
        int imported = 0;
        int BATCH_SIZE = 500;
        try (Connection con = DatabaseEditor.getConnection();){
            int n;
            block46: {
                PreparedStatement pstmt = con.prepareStatement(insertQuery);
                try {
                    con.setAutoCommit(false);
                    int batchCount = 0;
                    for (int i = 0; i < entries.size(); ++i) {
                        ExportEntry e = (ExportEntry)entries.get(i);
                        if (e.name == null) {
                            try {
                                OfflinePlayer p = PlayerHandler.getOfflinePlayer(UUID.fromString(e.uuid));
                                e.name = p.getName();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        pstmt.setString(1, e.uuid);
                        pstmt.setString(2, e.name);
                        pstmt.setString(3, e.home);
                        pstmt.setString(4, e.location);
                        pstmt.addBatch();
                        if (++batchCount < 500) continue;
                        pstmt.executeBatch();
                        con.commit();
                        pstmt.clearBatch();
                        imported += batchCount;
                        batchCount = 0;
                        DatabaseEditor.updateImportProgressToPlayer(sender, imported, entries.size());
                    }
                    if (batchCount > 0) {
                        pstmt.executeBatch();
                        con.commit();
                        imported += batchCount;
                    }
                    con.setAutoCommit(true);
                    if (sender != null) {
                        String message = "Import complete! " + imported + " records imported.";
                        LanguageBuilder.sendActionBar(sender, message);
                        try {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                player.playSound(player.getLocation(), Objects.requireNonNull(DatabaseEditor.getEntityLevelUP()), 100.0f, 1.0f);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    zHomes.getInstance().getLoggerInstance().info("Imported " + imported + " records from " + gzJsonFile.getAbsolutePath());
                    n = imported;
                    if (pstmt == null) break block46;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return n;
        }
        catch (SQLException e) {
            zHomes.getInstance().getLoggerInstance().error("Error importing database from " + gzJsonFile.getAbsolutePath(), e);
            if (sender != null) {
                LanguageBuilder.sendMessage(sender, "<red>Failed to import database. Check console for details.");
            }
            return -1;
        }
    }

    private static void updateImportProgressToPlayer(CommandSender sender, int count, int total) {
        if (sender != null) {
            String message = "<green>Importing data... <dark_gray>[<gray>" + count + " / " + total + "<dark_gray>]";
            LanguageBuilder.sendActionBar(sender, message);
        }
    }

    public static class PurgeFilter {
        private UUID playerUuid;
        private String worldName;
        private String homeStartsWith;
        private String homeEndsWith;
        private Map<UUID, List<String>> customFilter;

        private PurgeFilter() {
        }

        public static Builder builder() {
            return new Builder();
        }

        boolean hasInMemoryFilters() {
            return this.worldName != null || this.customFilter != null;
        }

        boolean matchesCustomFilter(UUID uuid, String homeName) {
            if (this.customFilter == null) {
                return true;
            }
            List<String> allowedHomes = this.customFilter.get(uuid);
            return allowedHomes != null && allowedHomes.contains(homeName);
        }

        public static class Builder {
            private final PurgeFilter filter = new PurgeFilter();

            public Builder player(OfflinePlayer player) {
                if (player != null) {
                    this.filter.playerUuid = player.getUniqueId();
                }
                return this;
            }

            public Builder playerUuid(UUID uuid) {
                this.filter.playerUuid = uuid;
                return this;
            }

            public Builder world(World world) {
                if (world != null) {
                    this.filter.worldName = world.getName();
                }
                return this;
            }

            public Builder worldName(String worldName) {
                this.filter.worldName = worldName;
                return this;
            }

            public Builder homeStartsWith(String prefix) {
                this.filter.homeStartsWith = prefix;
                return this;
            }

            public Builder homeEndsWith(String suffix) {
                this.filter.homeEndsWith = suffix;
                return this;
            }

            public Builder customFilter(Map<UUID, List<String>> customFilter) {
                this.filter.customFilter = customFilter;
                return this;
            }

            public PurgeFilter build() {
                return this.filter;
            }
        }
    }

    private static class ExportEntry {
        String uuid;
        String name;
        String home;
        String location;

        ExportEntry() {
        }

        ExportEntry(String uuid, String name, String home, String location) {
            this.uuid = uuid;
            this.name = name;
            this.home = home;
            this.location = location;
        }
    }
}

