/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.utility;

import io.github.miniplaceholders.api.MiniPlaceholders;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import me.yleoft.zHomes.libs.zAPI.configuration.Messages;
import me.yleoft.zHomes.libs.zAPI.hooks.HookRegistry;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFormatter {
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d+)(y|mo|w|d|h|m|s)", 2);
    private static final Map<String, Long> TIME_UNITS = Map.of("y", 31536000000L, "mo", 2592000000L, "w", 604800000L, "d", 86400000L, "h", 3600000L, "m", 60000L, "s", 1000L);
    private static final String[] TIME_SUFFIXES = new String[]{"y", "mo", "w", "d", "h", "m", "s"};

    public static boolean startsWithIgnoreCase(@NotNull String full, @NotNull String prefix) {
        return full.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    @NotNull
    public static Component transform(@Nullable OfflinePlayer p, @NotNull String string) {
        return TextFormatter.applyMiniPlaceholders(p, TextFormatter.transformString(p, string));
    }

    @NotNull
    public static String transformString(@Nullable OfflinePlayer p, @NotNull String string) {
        return TextFormatter.applyPlaceholders(p, string);
    }

    @NotNull
    public static Component transform(@Nullable OfflinePlayer p, @NotNull Component component) {
        return TextFormatter.applyMiniPlaceholders(p, TextFormatter.transformString(p, component));
    }

    @NotNull
    public static String transformString(@Nullable OfflinePlayer p, @NotNull Component component) {
        return TextFormatter.applyPlaceholders(p, (String)zAPI.getMiniMessage().serialize(component));
    }

    @NotNull
    public static Component transform(@NotNull String string) {
        return TextFormatter.transform(null, string);
    }

    @NotNull
    public static String transformString(@NotNull String string) {
        return TextFormatter.transformString(null, string);
    }

    @NotNull
    public static Component transform(@NotNull Component component) {
        return TextFormatter.transform(null, component);
    }

    @NotNull
    public static String transformString(@NotNull Component component) {
        return TextFormatter.transformString(null, component);
    }

    @NotNull
    public static String applyPlaceholders(@Nullable OfflinePlayer p, @NotNull String string) {
        if (p != null && HookRegistry.PAPI.exists()) {
            string = PlaceholderAPI.setPlaceholders((OfflinePlayer)p, (String)string);
        }
        string = string.replace("%prefix%", Messages.getPluginPrefix());
        return zAPI.getPlaceholdersHandler() != null ? zAPI.getPlaceholdersHandler().applyPlaceholders(p, string) : string;
    }

    public static Component applyMiniPlaceholders(@Nullable OfflinePlayer p, @NotNull String string) {
        if (!HookRegistry.MINI_PLACEHOLDERS.exists()) {
            return zAPI.getMiniMessage().deserialize((Object)string);
        }
        if (p instanceof Pointered) {
            Pointered pointered = (Pointered)p;
            return zAPI.getMiniMessage().deserialize(string, pointered, MiniPlaceholders.audienceGlobalPlaceholders());
        }
        return zAPI.getMiniMessage().deserialize(string, MiniPlaceholders.globalPlaceholders());
    }

    public static boolean isInteger(@NotNull String strNum) {
        try {
            Integer.parseInt(strNum);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static long parseAsTime(String time) {
        if (time == null || time.isEmpty()) {
            return 0L;
        }
        Matcher matcher = TIME_PATTERN.matcher(time);
        long totalMs = 0L;
        while (matcher.find()) {
            totalMs += Long.parseLong(matcher.group(1)) * TIME_UNITS.get(matcher.group(2).toLowerCase());
        }
        return totalMs;
    }

    public static String parseAsString(long ms) {
        if (ms <= 0L) {
            return "0s";
        }
        StringBuilder sb = new StringBuilder();
        for (String unit : TIME_SUFFIXES) {
            long unitMs = TIME_UNITS.get(unit);
            if (ms < unitMs) continue;
            sb.append(ms / unitMs).append(unit);
            ms %= unitMs;
        }
        return sb.toString();
    }
}

