/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.utility;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class MathExpressionEvaluator {
    public static double evaluate(@NotNull String expression) throws IllegalArgumentException {
        try {
            String cleaned = expression.replaceAll("\\s+", "");
            cleaned = MathExpressionEvaluator.processFunctions(cleaned);
            return MathExpressionEvaluator.evaluateExpression(cleaned);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid mathematical expression: " + expression, e);
        }
    }

    private static String processFunctions(@NotNull String expression) {
        String result = expression;
        result = MathExpressionEvaluator.processFunction(result, "roundDown", MathExpressionEvaluator::roundDown);
        result = MathExpressionEvaluator.processFunction(result, "round", MathExpressionEvaluator::round);
        result = MathExpressionEvaluator.processFunction(result, "sqrt", Math::sqrt);
        return result;
    }

    private static String processFunction(@NotNull String expression, @NotNull String functionName, @NotNull MathFunction function) {
        Pattern pattern = Pattern.compile(functionName + "\\(([^()]+)\\)");
        Matcher matcher = pattern.matcher(expression);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String innerExpression = matcher.group(1);
            double innerValue = MathExpressionEvaluator.evaluate(innerExpression);
            double functionResult = function.apply(innerValue);
            matcher.appendReplacement(result, String.valueOf(functionResult));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static double evaluateExpression(@NotNull String expression) {
        Stack<Double> values = new Stack<Double>();
        Stack<Character> operators = new Stack<Character>();
        for (int i = 0; i < expression.length(); ++i) {
            StringBuilder number;
            char c = expression.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (Character.isDigit(c) || c == '.') {
                number = new StringBuilder();
                while (i < expression.length() && (Character.isDigit(expression.charAt(i)) || expression.charAt(i) == '.')) {
                    number.append(expression.charAt(i));
                    ++i;
                }
                --i;
                values.push(Double.parseDouble(number.toString()));
                continue;
            }
            if (c == '(') {
                operators.push(Character.valueOf(c));
                continue;
            }
            if (c == ')') {
                while (!operators.isEmpty() && ((Character)operators.peek()).charValue() != '(') {
                    values.push(MathExpressionEvaluator.applyOperator(((Character)operators.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
                }
                if (operators.isEmpty()) continue;
                operators.pop();
                continue;
            }
            if (!MathExpressionEvaluator.isOperator(c)) continue;
            if (c == '-' && (i == 0 || expression.charAt(i - 1) == '(' || MathExpressionEvaluator.isOperator(expression.charAt(i - 1)))) {
                number = new StringBuilder("-");
                ++i;
                while (i < expression.length() && (Character.isDigit(expression.charAt(i)) || expression.charAt(i) == '.')) {
                    number.append(expression.charAt(i));
                    ++i;
                }
                --i;
                values.push(Double.parseDouble(number.toString()));
                continue;
            }
            while (!operators.isEmpty() && MathExpressionEvaluator.precedence(c) <= MathExpressionEvaluator.precedence(((Character)operators.peek()).charValue())) {
                values.push(MathExpressionEvaluator.applyOperator(((Character)operators.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
            }
            operators.push(Character.valueOf(c));
        }
        while (!operators.isEmpty()) {
            values.push(MathExpressionEvaluator.applyOperator(((Character)operators.pop()).charValue(), (Double)values.pop(), (Double)values.pop()));
        }
        return values.isEmpty() ? 0.0 : (Double)values.pop();
    }

    private static boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/';
    }

    private static int precedence(char operator) {
        switch (operator) {
            case '+': 
            case '-': {
                return 1;
            }
            case '*': 
            case '/': {
                return 2;
            }
        }
        return 0;
    }

    private static double applyOperator(char operator, double b, double a) {
        switch (operator) {
            case '+': {
                return a + b;
            }
            case '-': {
                return a - b;
            }
            case '*': {
                return a * b;
            }
            case '/': {
                if (b == 0.0) {
                    throw new ArithmeticException("Division by zero");
                }
                return a / b;
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + operator);
    }

    private static double round(double value) {
        return Math.round(value);
    }

    private static double roundDown(double value) {
        return Math.floor(value);
    }

    @FunctionalInterface
    private static interface MathFunction {
        public double apply(double var1);
    }
}

