/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.utility;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ExternalDependencyManager {
    public static volatile File STATIC_DIRECTORY = null;
    private final HttpClient httpClient;
    private final Map<String, RegisteredDependency> registry = new ConcurrentHashMap<String, RegisteredDependency>();

    public ExternalDependencyManager() {
        this(HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(20L)).build());
    }

    public ExternalDependencyManager(HttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient");
    }

    public void registerDependency(String id, URI jarUrl) {
        ExternalDependencyManager.validateId(id);
        Objects.requireNonNull(jarUrl, "jarUrl");
        if (!jarUrl.toString().endsWith(".jar")) {
            throw new IllegalArgumentException("jarUrl must point to a .jar: " + String.valueOf(jarUrl));
        }
        this.registry.put(id, new RegisteredDependency(id, jarUrl));
    }

    public boolean isRegistered(String id) {
        return this.registry.containsKey(id);
    }

    public Set<String> getRegisteredIds() {
        return Collections.unmodifiableSet(this.registry.keySet());
    }

    public RegisteredDependency getRegistered(String id) {
        RegisteredDependency dep = this.registry.get(id);
        if (dep == null) {
            throw new IllegalArgumentException("Unknown dependency id: " + id);
        }
        return dep;
    }

    public Path download(String id) throws IOException, InterruptedException {
        RegisteredDependency dep = this.getRegistered(id);
        Path baseDir = this.ensureStaticDir();
        String fileName = ExternalDependencyManager.safeFileName(dep.id()) + "-" + ExternalDependencyManager.shortHash(dep.jarUrl().toString()) + ".jar";
        Path out = baseDir.resolve("downloads").resolve(fileName);
        Files.createDirectories(out.getParent(), new FileAttribute[0]);
        if (Files.exists(out, new LinkOption[0]) && Files.size(out) > 0L) {
            return out;
        }
        HttpRequest req = HttpRequest.newBuilder(dep.jarUrl()).GET().timeout(Duration.ofMinutes(2L)).build();
        Path tmp = out.resolveSibling(String.valueOf(out.getFileName()) + ".part");
        Files.deleteIfExists(tmp);
        HttpResponse<Path> resp = this.httpClient.send(req, HttpResponse.BodyHandlers.ofFile(tmp));
        if (resp.statusCode() < 200 || resp.statusCode() >= 300) {
            Files.deleteIfExists(tmp);
            throw new IOException("Failed to download " + String.valueOf(dep.jarUrl()) + " (HTTP " + resp.statusCode() + ")");
        }
        Files.move(tmp, out, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        return out;
    }

    public Map<String, Path> downloadAll() throws IOException, InterruptedException {
        LinkedHashMap<String, Path> result = new LinkedHashMap<String, Path>();
        for (String id : this.sortedIds()) {
            result.put(id, this.download(id));
        }
        return result;
    }

    public URLClassLoader loadIsolated(String id, ClassLoader parent) throws IOException, InterruptedException {
        Path jar = this.download(id);
        URL url = jar.toUri().toURL();
        return new URLClassLoader(new URL[]{url}, parent);
    }

    public URLClassLoader loadAllIntoOneIsolatedLoader(ClassLoader parent) throws IOException, InterruptedException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String id : this.sortedIds()) {
            urls.add(this.download(id).toUri().toURL());
        }
        return new URLClassLoader((URL[])urls.toArray(URL[]::new), parent);
    }

    public Map<String, URLClassLoader> loadEachIsolated(ClassLoader parent) throws IOException, InterruptedException {
        LinkedHashMap<String, URLClassLoader> loaders = new LinkedHashMap<String, URLClassLoader>();
        for (String id : this.sortedIds()) {
            loaders.put(id, this.loadIsolated(id, parent));
        }
        return loaders;
    }

    private Path ensureStaticDir() throws IOException {
        File dir = STATIC_DIRECTORY;
        if (dir == null) {
            throw new IllegalStateException("ExternalDependencyManager.STATIC_DIRECTORY must be set by the user before use.");
        }
        Path p = dir.toPath().toAbsolutePath().normalize();
        Files.createDirectories(p, new FileAttribute[0]);
        return p;
    }

    private static void validateId(String id) {
        Objects.requireNonNull(id, "id");
        if (id.isBlank()) {
            throw new IllegalArgumentException("id is blank");
        }
    }

    private static String safeFileName(String s) {
        return s.replaceAll("[^a-zA-Z0-9._-]", "_");
    }

    private static List<String> sortedIdsFrom(Set<String> ids) {
        ArrayList<String> list = new ArrayList<String>(ids);
        Collections.sort(list);
        return list;
    }

    private List<String> sortedIds() {
        return ExternalDependencyManager.sortedIdsFrom(this.registry.keySet());
    }

    private static String shortHash(String in) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digest = md.digest(in.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 6; ++i) {
                sb.append(String.format("%02x", digest[i]));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public record RegisteredDependency(String id, URI jarUrl) {
    }
}

