/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.location;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocationHandler {
    private static final EnumSet<Material> blacklistedGround = EnumSet.noneOf(Material.class);

    public static String serialize(@NotNull Location location) {
        String world = Objects.requireNonNull(location.getWorld()).getName();
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        float yaw = location.getYaw();
        float pitch = location.getPitch();
        return LocationHandler.serialize(world, x, y, z, yaw, pitch);
    }

    public static String serialize(@NotNull String world, double x, double y, double z, float yaw, float pitch) {
        return String.join((CharSequence)";", world, String.valueOf(x), String.valueOf(y), String.valueOf(z), String.valueOf(yaw), String.valueOf(pitch));
    }

    public static Location deserialize(@NotNull String serialized) {
        String[] parts = serialized.split(";");
        if (parts.length != 6) {
            throw new IllegalArgumentException("Invalid serialized location format. Expected 6 parts but got " + parts.length + ": " + serialized);
        }
        try {
            World w = Bukkit.getWorld((String)parts[0]);
            double x = Double.parseDouble(parts[1]);
            double y = Double.parseDouble(parts[2]);
            double z = Double.parseDouble(parts[3]);
            float yaw = Float.parseFloat(parts[4]);
            float pitch = Float.parseFloat(parts[5]);
            return new Location(w, x, y, z, yaw, pitch);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number format in serialized location: " + serialized, e);
        }
    }

    @Nullable
    public static Location findNearestSafeLocation(@NotNull Location origin, int radius, int heightCheckRange) {
        if (LocationHandler.isSafeLocation(origin)) {
            return origin;
        }
        World world = origin.getWorld();
        if (world == null) {
            return null;
        }
        int ox = origin.getBlockX();
        int oy = origin.getBlockY();
        int oz = origin.getBlockZ();
        ArrayList<Integer> yOffsets = new ArrayList<Integer>();
        for (int i = 0; i <= heightCheckRange; ++i) {
            yOffsets.add(i);
            if (i == 0) continue;
            yOffsets.add(-i);
        }
        Location bestLoc = null;
        double bestDistSq = Double.MAX_VALUE;
        MutableBlockLocation check = new MutableBlockLocation(world, ox, oy, oz);
        for (int r = 0; r <= radius; ++r) {
            for (int x = -r; x <= r; ++x) {
                for (int z = -r; z <= r; ++z) {
                    if (Math.abs(x) != r && Math.abs(z) != r) continue;
                    Iterator iterator = yOffsets.iterator();
                    while (iterator.hasNext()) {
                        double distSq;
                        int maxY;
                        int minY;
                        int yOffset = (Integer)iterator.next();
                        int y = oy + yOffset;
                        try {
                            minY = world.getMinHeight();
                            maxY = world.getMaxHeight();
                        }
                        catch (Throwable ignored) {
                            minY = 0;
                            maxY = 256;
                        }
                        if (y < minY || y > maxY) continue;
                        check.set(ox + x, y, oz + z);
                        Location temp = check.toLocation();
                        if (!LocationHandler.isSafeLocation(temp) || !((distSq = temp.distanceSquared(origin)) < bestDistSq)) continue;
                        bestDistSq = distSq;
                        bestLoc = temp.add(0.5, 0.0, 0.5);
                    }
                }
            }
        }
        return bestLoc;
    }

    @NotNull
    public static CompletableFuture<Location> findNearestSafeLocationAsync(@NotNull Location origin, int radius, int heightCheckRange) {
        CompletableFuture<Location> future = new CompletableFuture<Location>();
        zAPI.getScheduler().runAtLocation(origin, task -> {
            try {
                Location result = LocationHandler.findNearestSafeLocation(origin, radius, heightCheckRange);
                future.complete(result);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static boolean isSafeLocation(@NotNull Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            return false;
        }
        Block feet = world.getBlockAt(loc);
        Block head = world.getBlockAt(loc.clone().add(0.0, 1.0, 0.0));
        Block ground = world.getBlockAt(loc.clone().add(0.0, -1.0, 0.0));
        return LocationHandler.isAirOrNonSolid(feet) && LocationHandler.isAirOrNonSolid(head) && LocationHandler.isSafeGround(ground);
    }

    @NotNull
    public static CompletableFuture<Boolean> isSafeLocationAsync(@NotNull Location loc) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        zAPI.getScheduler().runAtLocation(loc, task -> {
            try {
                boolean result = LocationHandler.isSafeLocation(loc);
                future.complete(result);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private static boolean isAirOrNonSolid(@NotNull Block block) {
        return !block.getType().isSolid() && !block.isLiquid();
    }

    private static boolean isSafeGround(@NotNull Block block) {
        Material type = block.getType();
        return block.getType().isSolid() && !block.isLiquid() && !blacklistedGround.contains(type);
    }

    static {
        for (String name : Arrays.asList("CACTUS", "FIRE", "LAVA", "MAGMA_BLOCK", "CAMPFIRE", "SOUL_FIRE")) {
            try {
                blacklistedGround.add(Material.valueOf((String)name));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public static class MutableBlockLocation {
        private final World world;
        private int x;
        private int y;
        private int z;

        public MutableBlockLocation(World world, int x, int y, int z) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void set(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Block getBlock() {
            return this.world.getBlockAt(this.x, this.y, this.z);
        }

        public Location toLocation() {
            return new Location(this.world, (double)this.x, (double)this.y, (double)this.z);
        }
    }
}

