/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.hooks;

import java.util.ArrayList;
import java.util.List;
import me.yleoft.zHomes.libs.zAPI.hooks.HookInstance;
import me.yleoft.zHomes.libs.zAPI.hooks.HookMiniPlaceholders;
import me.yleoft.zHomes.libs.zAPI.hooks.HookPlaceholderAPI;
import me.yleoft.zHomes.libs.zAPI.zAPI;

public class HookRegistry {
    private static final List<HookInstance> Hooks = new ArrayList<HookInstance>();
    public static final HookPlaceholderAPI PAPI = new HookPlaceholderAPI();
    public static final HookMiniPlaceholders MINI_PLACEHOLDERS = new HookMiniPlaceholders();

    public static void preload() {
        try {
            boolean debugMode = zAPI.getPluginLogger().isDebugMode();
            zAPI.getPluginLogger().setDebugMode(true);
            if (!Hooks.contains(PAPI)) {
                Hooks.add(PAPI);
            }
            if (!Hooks.contains(MINI_PLACEHOLDERS)) {
                Hooks.add(MINI_PLACEHOLDERS);
            }
            Hooks.forEach(instance -> {
                try {
                    instance.preload();
                }
                catch (Exception | NoClassDefFoundError exception) {
                    zAPI.getPluginLogger().error("Failed to preload hook: " + instance.getClass().getSimpleName(), exception);
                }
            });
            Hooks.stream().filter(HookInstance::exists).map(HookInstance::preloadMessage).forEach(zAPI.getPluginLogger()::info);
            zAPI.getPluginLogger().setDebugMode(debugMode);
        }
        catch (Exception | NoClassDefFoundError exception) {
            zAPI.getPluginLogger().error("Unable to pre load hooks.", exception);
        }
    }

    public static void load() {
        try {
            if (!Hooks.contains(PAPI)) {
                Hooks.add(PAPI);
            }
            if (!Hooks.contains(MINI_PLACEHOLDERS)) {
                Hooks.add(MINI_PLACEHOLDERS);
            }
            Hooks.forEach(instance -> {
                try {
                    instance.load();
                }
                catch (Exception | NoClassDefFoundError exception) {
                    zAPI.getPluginLogger().error("Failed to load hook: " + instance.getClass().getSimpleName(), exception);
                }
            });
            Hooks.stream().filter(HookInstance::exists).map(HookInstance::message).forEach(zAPI.getPluginLogger()::info);
        }
        catch (Exception exception) {
            zAPI.getPluginLogger().error("Unable to initialise hooks.", exception);
        }
    }

    public static void unload() {
        Hooks.forEach(instance -> {
            try {
                instance.unload();
            }
            catch (Exception exception) {
                zAPI.getPluginLogger().error("Failed to unload hook: " + instance.getClass().getSimpleName(), exception);
            }
        });
    }

    public static void registerHook(HookInstance hookInstance) {
        Hooks.add(hookInstance);
    }

    public static void clearHooks() {
        Hooks.clear();
    }
}

