/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.hooks;

import io.github.miniplaceholders.api.Expansion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.yleoft.zHomes.libs.zAPI.handlers.PlaceholderDefinition;
import me.yleoft.zHomes.libs.zAPI.handlers.PlaceholderType;
import me.yleoft.zHomes.libs.zAPI.handlers.PlaceholdersHandler;
import me.yleoft.zHomes.libs.zAPI.hooks.HookInstance;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import net.kyori.adventure.text.minimessage.tag.Tag;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class HookMiniPlaceholders
implements HookInstance {
    public static String message = "MiniPlaceholders has been found, mini placeholders are enabled!";
    private final Map<PlaceholdersHandler, Expansion> expansions = new HashMap<PlaceholdersHandler, Expansion>();
    private boolean exists = false;

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public void load() {
        if (!Bukkit.getPluginManager().isPluginEnabled("MiniPlaceholders")) {
            return;
        }
        this.exists = true;
    }

    @Override
    public void unload() {
        if (!this.exists()) {
            return;
        }
        for (PlaceholdersHandler handler : new HashMap<PlaceholdersHandler, Expansion>(this.expansions).keySet()) {
            this.unregisterPlaceholderExpansion(handler);
        }
    }

    @Override
    public String message() {
        return message;
    }

    public void registerPlaceholderExpansion(PlaceholdersHandler handler) {
        if (!this.exists()) {
            return;
        }
        try {
            Expansion.Builder builder = Expansion.builder((String)handler.getIdentifier()).author(handler.getAuthor()).version(handler.getVersion());
            for (PlaceholderDefinition definition : handler.getPlaceholders()) {
                String miniKey = definition.getKey();
                int paramCount = definition.getParameterCount();
                PlaceholderType type = definition.getType();
                switch (type) {
                    case GLOBAL: {
                        builder.globalPlaceholder(miniKey, (queue, ctx) -> {
                            ArrayList<String> args = new ArrayList<String>();
                            for (int i = 0; i < paramCount; ++i) {
                                if (!queue.hasNext()) continue;
                                try {
                                    args.add(queue.pop().value());
                                    continue;
                                }
                                catch (Exception e) {
                                    args.add("");
                                }
                            }
                            String result = handler.onPlaceholderRequest(null, miniKey, args);
                            if (result == null) {
                                result = "";
                            }
                            return Tag.preProcessParsed((String)result);
                        });
                        break;
                    }
                    case PLAYER_TARGETED: {
                        builder.globalPlaceholder(miniKey, (queue, ctx) -> {
                            OfflinePlayer targetPlayer = null;
                            if (queue.hasNext()) {
                                try {
                                    String targetName = queue.pop().value();
                                    if (targetName != null && !targetName.isEmpty()) {
                                        targetPlayer = Bukkit.getOfflinePlayer((String)targetName);
                                    }
                                }
                                catch (Exception e) {
                                    return Tag.preProcessParsed((String)"");
                                }
                            }
                            ArrayList<String> args = new ArrayList<String>();
                            for (int i = 0; i < paramCount; ++i) {
                                if (!queue.hasNext()) continue;
                                try {
                                    args.add(queue.pop().value());
                                    continue;
                                }
                                catch (Exception e) {
                                    args.add("");
                                }
                            }
                            String result = handler.onPlaceholderRequest(targetPlayer, miniKey, args);
                            if (result == null) {
                                result = "";
                            }
                            return Tag.preProcessParsed((String)result);
                        });
                        break;
                    }
                    case AUDIENCE: {
                        builder.audiencePlaceholder(Player.class, miniKey, (player, queue, ctx) -> {
                            ArrayList<String> args = new ArrayList<String>();
                            for (int i = 0; i < paramCount; ++i) {
                                if (!queue.hasNext()) continue;
                                try {
                                    args.add(queue.pop().value());
                                    continue;
                                }
                                catch (Exception e) {
                                    args.add("");
                                }
                            }
                            Player offlinePlayer = player;
                            String result = handler.onPlaceholderRequest((OfflinePlayer)offlinePlayer, miniKey, args);
                            if (result == null) {
                                result = "";
                            }
                            return Tag.preProcessParsed((String)result);
                        });
                    }
                }
            }
            Expansion expansion = (Expansion)builder.build();
            expansion.register();
            this.expansions.put(handler, expansion);
        }
        catch (Exception exception) {
            zAPI.getLogger().warn("Failed to register MiniPlaceholders expansion for: " + handler.getIdentifier(), exception);
        }
    }

    public void unregisterPlaceholderExpansion(PlaceholdersHandler handler) {
        if (!this.exists()) {
            return;
        }
        Expansion expansion = this.expansions.remove(handler);
        if (expansion != null) {
            try {
                expansion.unregister();
            }
            catch (Exception exception) {
                zAPI.getLogger().warn("Failed to unregister MiniPlaceholders expansion for: " + handler.getIdentifier(), exception);
            }
        }
    }

    public static void setMessage(String message) {
        HookMiniPlaceholders.message = message;
    }
}

