/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.configuration;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.yleoft.zHomes.libs.zAPI.configuration.YAMLBuilder;
import me.yleoft.zHomes.libs.zAPI.zAPI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class LanguageManager {
    private final List<YAMLBuilder> languages;
    private final String languageCode;
    private final String fallbackLanguageCode;
    private final Map<String, Object> options = new HashMap<String, Object>();
    private final Map<String, Object> fallbackOptions = new HashMap<String, Object>();
    private final YAMLBuilder languageBuilder;
    private YAMLBuilder fallbackBuilder;

    public LanguageManager(@NotNull List<YAMLBuilder> languages, @NotNull String languageCode) throws IOException {
        this(languages, languageCode, null);
    }

    public LanguageManager(@NotNull List<YAMLBuilder> languages, @NotNull String languageCode, @Nullable String fallbackLanguageCode) throws IOException {
        this.languages = languages;
        this.languageCode = languageCode;
        this.fallbackLanguageCode = fallbackLanguageCode;
        this.languageBuilder = this.findLanguageBuilder(languageCode);
        if (this.languageBuilder == null) {
            zAPI.getLogger().warn("Language file not found for code: " + languageCode);
        }
        if (fallbackLanguageCode != null) {
            this.fallbackBuilder = this.findLanguageBuilder(fallbackLanguageCode);
            if (this.fallbackBuilder == null) {
                zAPI.getLogger().warn("Fallback language file not found for code: " + fallbackLanguageCode);
            }
        }
        this.load();
    }

    private YAMLBuilder findLanguageBuilder(String code) {
        for (YAMLBuilder builder : this.languages) {
            if (!builder.getFile().getName().equals(code + ".yml")) continue;
            return builder;
        }
        return null;
    }

    public void reload() throws IOException {
        this.options.clear();
        this.fallbackOptions.clear();
        this.load();
    }

    public Object get(@NotNull String path) {
        if (this.options.containsKey(path)) {
            return this.options.get(path);
        }
        if (this.fallbackLanguageCode != null && this.fallbackOptions.containsKey(path)) {
            return this.fallbackOptions.get(path);
        }
        return null;
    }

    public String getString(@NotNull String path) {
        Object value = this.get(path);
        return value != null ? value.toString() : null;
    }

    private void load() throws IOException {
        Object data;
        Yaml yaml;
        try {
            Class<?> loaderOptionsClass = Class.forName("org.yaml.snakeyaml.LoaderOptions");
            yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        }
        catch (ClassNotFoundException | NoSuchMethodError e) {
            yaml = new Yaml();
        }
        try (FileInputStream inputStream = new FileInputStream(this.languageBuilder.getFile());){
            data = yaml.load((InputStream)inputStream);
            if (data instanceof Map) {
                this.flattenMap("", (Map)data, this.options);
            }
        }
        if (this.fallbackBuilder != null) {
            inputStream = new FileInputStream(this.fallbackBuilder.getFile());
            try {
                data = yaml.load((InputStream)inputStream);
                if (data instanceof Map) {
                    this.flattenMap("", (Map)data, this.fallbackOptions);
                }
            }
            finally {
                inputStream.close();
            }
        }
    }

    private void flattenMap(String prefix, Map<?, ?> source, Map<String, Object> target) {
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            String fullPath;
            String key = entry.getKey().toString();
            String string = fullPath = prefix.isEmpty() ? key : prefix + "." + key;
            if (entry.getValue() instanceof Map) {
                this.flattenMap(fullPath, (Map)entry.getValue(), target);
                continue;
            }
            target.put(fullPath, entry.getValue());
        }
    }

    public String getCurrentLanguage() {
        return this.languageCode;
    }

    public String getFallbackLanguage() {
        return this.fallbackLanguageCode;
    }

    public List<YAMLBuilder> getLanguages() {
        return this.languages;
    }
}

