/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.command;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Parameter {
    @NotNull
    public String name();

    @NotNull
    default public List<String> aliases() {
        return List.of();
    }

    default public String permission() {
        return null;
    }

    default public boolean stopSubCommands() {
        return false;
    }

    default public int minArgs() {
        return 0;
    }

    default public int maxArgs() {
        return Integer.MAX_VALUE;
    }

    @Nullable
    default public Set<String> whitelist() {
        return null;
    }

    @Nullable
    default public String whitelistMessage() {
        return null;
    }

    default public boolean isWhitelisted(@NotNull String value) {
        Set<String> whitelist = this.whitelist();
        if (whitelist == null || whitelist.isEmpty()) {
            return true;
        }
        Set lowercaseWhitelist = whitelist.stream().map(String::toLowerCase).collect(Collectors.toSet());
        return lowercaseWhitelist.contains(value.toLowerCase());
    }

    default public void execute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] parameterArgs) {
    }

    @NotNull
    default public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] parameterArgs) {
        return List.of();
    }
}

