/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.libs.zAPI.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.yleoft.zHomes.libs.zAPI.command.Parameter;
import me.yleoft.zHomes.libs.zAPI.command.SubCommand;
import me.yleoft.zHomes.libs.zAPI.configuration.Messages;
import me.yleoft.zHomes.libs.zAPI.utility.TextFormatter;
import net.kyori.adventure.text.Component;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CommandBasis
extends CommandExecutor,
TabCompleter {
    public static final Map<CommandBasis, List<SubCommand>> subCommands = new HashMap<CommandBasis, List<SubCommand>>();
    public static final Map<CommandBasis, List<Parameter>> parameters = new HashMap<CommandBasis, List<Parameter>>();
    public static final Map<UUID, Map<Parameter, String[]>> activeParameters = new HashMap<UUID, Map<Parameter, String[]>>();

    @NotNull
    public String name();

    default public String description() {
        return "";
    }

    default public List<String> aliases() {
        return List.of();
    }

    default public int minArgs() {
        return 0;
    }

    default public int maxArgs() {
        return Integer.MAX_VALUE;
    }

    default public boolean playerOnly() {
        return false;
    }

    default public String permission() {
        return null;
    }

    default public String usage(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        return "";
    }

    default public String permissionMessage() {
        return Messages.getNoPermissionDefault();
    }

    default public String playerOnlyMessage() {
        return Messages.getOnlyPlayersDefault();
    }

    default public boolean prexecute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull @NotNull String @NotNull [] args) {
        return false;
    }

    public void execute(@NotNull CommandSender var1, @NotNull String[] var2, @NotNull @NotNull String @NotNull [] var3);

    default public void addParameter(@NotNull Parameter parameter) {
        parameters.computeIfAbsent(this, k -> new ArrayList()).add(parameter);
    }

    @Nullable
    default public String[] getParameter(@NotNull CommandSender sender, @NotNull Parameter parameter) {
        if (!(sender instanceof Player)) {
            return null;
        }
        Player p = (Player)sender;
        Map<Parameter, String[]> map = activeParameters.get(p.getUniqueId());
        return map == null ? null : map.get(parameter);
    }

    default public void clearParameters(@NotNull CommandSender sender) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            activeParameters.remove(p.getUniqueId());
        }
    }

    default public void dispatch(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        if (this.playerOnly() && !this.isPlayer(sender)) {
            this.message(sender, this.playerOnlyMessage());
            return;
        }
        if (this.permission() != null && !sender.hasPermission(this.permission())) {
            this.message(sender, this.permissionMessage());
            return;
        }
        ParameterParseResult parsed = this.parseAndExecuteParameters(sender, fullArgs, args);
        if (parsed.stopFurtherDispatch) {
            return;
        }
        args = parsed.remainingArgs;
        if (this.prexecute(sender, fullArgs, args)) {
            return;
        }
        if (this.minArgs() > 0 && args.length < this.minArgs()) {
            this.message(sender, this.usage(sender, fullArgs, args));
            return;
        }
        if (args.length > this.maxArgs()) {
            this.message(sender, this.usage(sender, fullArgs, args));
            return;
        }
        if (args.length > 0 && subCommands.containsKey(this)) {
            String first = args[0];
            for (CommandBasis commandBasis : subCommands.get(this)) {
                boolean matches = commandBasis.name().equalsIgnoreCase(first) || commandBasis.aliases().stream().anyMatch(a -> a.equalsIgnoreCase(first));
                if (!matches) continue;
                String[] subArgs = new String[args.length - 1];
                System.arraycopy(args, 1, subArgs, 0, args.length - 1);
                commandBasis.dispatch(sender, fullArgs, subArgs);
                return;
            }
        }
        this.execute(sender, fullArgs, args);
    }

    @NotNull
    default public ParameterParseResult parseAndExecuteParameters(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        List<Parameter> list = parameters.getOrDefault(this, List.of());
        if (list.isEmpty() || args.length == 0) {
            return new ParameterParseResult(args, false);
        }
        boolean stop = false;
        HashSet<Parameter> alreadyUsed = new HashSet<Parameter>();
        ArrayList<String> remaining = new ArrayList<String>(args.length);
        int i = 0;
        while (i < args.length) {
            String[] paramArgs;
            String next;
            int taken;
            String token = args[i];
            if (token == null || token.isEmpty() || token.charAt(0) != '-') {
                remaining.add(token);
                ++i;
                continue;
            }
            String rawName = token.substring(1);
            Parameter param = this.findParameter(list, rawName);
            if (param == null) {
                remaining.add(token);
                ++i;
                continue;
            }
            if (alreadyUsed.contains(param)) {
                remaining.add(token);
                ++i;
                continue;
            }
            if (param.permission() != null && !sender.hasPermission(param.permission())) {
                remaining.add(token);
                ++i;
                continue;
            }
            int start = i + 1;
            int maxTake = Math.min(param.maxArgs(), args.length - start);
            for (taken = 0; !(taken >= maxTake || (next = args[start + taken]) != null && next.startsWith("-") && this.findParameter(list, next.substring(1)) != null); ++taken) {
            }
            if (taken < param.minArgs()) {
                remaining.add(token);
                ++i;
                continue;
            }
            for (String arg : paramArgs = Arrays.copyOfRange(args, start, start + taken)) {
                if (param.isWhitelisted(arg)) continue;
                if (param.whitelistMessage() != null) {
                    this.message(sender, param.whitelistMessage());
                }
                return new ParameterParseResult(new String[0], true);
            }
            alreadyUsed.add(param);
            if (sender instanceof Player) {
                Player p = (Player)sender;
                activeParameters.computeIfAbsent(p.getUniqueId(), k -> new HashMap()).put(param, paramArgs);
            }
            param.execute(sender, fullArgs, paramArgs);
            if (param.stopSubCommands()) {
                stop = true;
            }
            i = start + taken;
        }
        if (stop) {
            return new ParameterParseResult(new String[0], true);
        }
        return new ParameterParseResult(remaining.toArray(new String[0]), false);
    }

    @Nullable
    default public ParameterTabContext findActiveParameterTabContext(@NotNull CommandSender sender, @NotNull String[] args) {
        List<Parameter> list = parameters.getOrDefault(this, List.of());
        if (list.isEmpty() || args.length == 0) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            boolean stillTyping;
            boolean cursorWithinThisParam;
            int start;
            String next;
            int endExclusive;
            Parameter param;
            String token = args[i];
            if (token == null || token.isEmpty() || token.charAt(0) != '-' || (param = this.findParameter(list, token.substring(1))) == null || param.permission() != null && !sender.hasPermission(param.permission())) continue;
            for (endExclusive = start = i + 1; !(endExclusive >= args.length || (next = args[endExclusive]) != null && next.startsWith("-") && this.findParameter(list, next.substring(1)) != null); ++endExclusive) {
            }
            boolean bl = cursorWithinThisParam = args.length >= start && args.length <= endExclusive;
            if (!cursorWithinThisParam) continue;
            String[] soFarRaw = Arrays.copyOfRange(args, start, endExclusive);
            int effectiveCount = soFarRaw.length;
            boolean bl2 = stillTyping = effectiveCount > 0 && soFarRaw[effectiveCount - 1] != null && !soFarRaw[effectiveCount - 1].isEmpty();
            if (effectiveCount > 0 && soFarRaw[effectiveCount - 1] != null && soFarRaw[effectiveCount - 1].isEmpty()) {
                --effectiveCount;
            }
            if (stillTyping && effectiveCount > param.maxArgs()) {
                return null;
            }
            if (!stillTyping && effectiveCount >= param.maxArgs()) {
                return null;
            }
            return new ParameterTabContext(param, soFarRaw);
        }
        return null;
    }

    @Nullable
    default public Parameter findParameter(@NotNull List<Parameter> list, @NotNull String nameOrAlias) {
        for (Parameter p : list) {
            if (p.name().equalsIgnoreCase(nameOrAlias)) {
                return p;
            }
            for (String a : p.aliases()) {
                if (!a.equalsIgnoreCase(nameOrAlias)) continue;
                return p;
            }
        }
        return null;
    }

    @NotNull
    default public List<String> dispatchTabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        String last;
        if (this.playerOnly() && !this.isPlayer(sender)) {
            return List.of();
        }
        if (this.permission() != null && !sender.hasPermission(this.permission())) {
            return List.of();
        }
        if (args.length > 1 && subCommands.containsKey(this)) {
            String first = args[0];
            for (CommandBasis commandBasis : subCommands.get(this)) {
                boolean matches = commandBasis.name().equalsIgnoreCase(first) || commandBasis.aliases().stream().anyMatch(a -> a.equalsIgnoreCase(first));
                if (!matches) continue;
                if (commandBasis.permission() != null && !sender.hasPermission(commandBasis.permission())) {
                    return List.of();
                }
                String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
                return commandBasis.dispatchTabComplete(sender, fullArgs, subArgs);
            }
        }
        if (args.length > 0 && (last = args[args.length - 1]).startsWith("-")) {
            return this.filterCompletions(args, this.suggestParameters(sender));
        }
        ParameterTabContext ctx = this.findActiveParameterTabContext(sender, args);
        if (ctx != null) {
            List<String> suggestions = ctx.parameter.tabComplete(sender, fullArgs, ctx.parameterArgsSoFar);
            return this.filterCompletions(args, suggestions);
        }
        ArrayList<String> base = new ArrayList<String>(this.tabComplete(sender, fullArgs, args));
        return this.filterCompletions(args, base);
    }

    @NotNull
    default public List<String> suggestParameters(@NotNull CommandSender sender) {
        List list = parameters.getOrDefault(this, List.of());
        if (list.isEmpty()) {
            return List.of();
        }
        ArrayList<String> out = new ArrayList<String>();
        for (Parameter p : list) {
            if (p.permission() != null && !sender.hasPermission(p.permission())) continue;
            out.add("-" + p.name());
        }
        return out;
    }

    @NotNull
    default public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        return List.of();
    }

    default public boolean isPlayer(@NotNull CommandSender sender) {
        return sender instanceof Player;
    }

    default public void message(CommandSender sender, @Nullable String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        sender.sendMessage(TextFormatter.transform((OfflinePlayer)(sender instanceof Player ? (Player)sender : null), message));
    }

    default public void message(CommandSender sender, @Nullable Component message) {
        if (message == null) {
            return;
        }
        sender.sendMessage(TextFormatter.transform((OfflinePlayer)(sender instanceof Player ? (Player)sender : null), message));
    }

    default public void addSubCommand(SubCommand subCommand) {
        subCommands.computeIfAbsent(this, k -> new ArrayList()).add(subCommand);
    }

    default public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        this.clearParameters(sender);
        this.dispatch(sender, args, args);
        return true;
    }

    default public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        return this.dispatchTabComplete(sender, args, args);
    }

    @NotNull
    default public List<String> filterCompletions(@NotNull String[] args, @NotNull Collection<String> candidates) {
        String prefix = args.length == 0 ? "" : args[args.length - 1];
        String p = prefix.toLowerCase(Locale.ROOT);
        LinkedHashSet<String> out = new LinkedHashSet<String>();
        for (String c : candidates) {
            if (c == null || !p.isEmpty() && !c.toLowerCase(Locale.ROOT).startsWith(p)) continue;
            out.add(c);
        }
        return new ArrayList<String>(out);
    }

    public static final class ParameterParseResult {
        final String[] remainingArgs;
        final boolean stopFurtherDispatch;

        ParameterParseResult(String[] remainingArgs, boolean stopFurtherDispatch) {
            this.remainingArgs = remainingArgs;
            this.stopFurtherDispatch = stopFurtherDispatch;
        }
    }

    public static final class ParameterTabContext {
        final Parameter parameter;
        final String[] parameterArgsSoFar;

        ParameterTabContext(Parameter parameter, String[] parameterArgsSoFar) {
            this.parameter = parameter;
            this.parameterArgsSoFar = parameterArgsSoFar;
        }
    }
}

