/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.hooks;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import me.yleoft.zHomes.libs.zAPI.handlers.PlaceholderDefinition;
import me.yleoft.zHomes.libs.zAPI.handlers.PlaceholderType;
import me.yleoft.zHomes.libs.zAPI.handlers.PlaceholdersHandler;
import me.yleoft.zHomes.libs.zAPI.player.PlayerHandler;
import me.yleoft.zHomes.libs.zAPI.utility.TextFormatter;
import me.yleoft.zHomes.utility.HomesUtils;
import me.yleoft.zHomes.zHomes;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HookPAPI
implements PlaceholdersHandler {
    @Override
    @NotNull
    public String getIdentifier() {
        return "zhomes";
    }

    @Override
    @NotNull
    public List<PlaceholderDefinition> getPlaceholders() {
        return List.of(new PlaceholderDefinition("version", 0, PlaceholderType.GLOBAL), new PlaceholderDefinition("set", 0, PlaceholderType.AUDIENCE), new PlaceholderDefinition("numberofhomes", 0, PlaceholderType.AUDIENCE), new PlaceholderDefinition("limit", 0, PlaceholderType.AUDIENCE), new PlaceholderDefinition("max", 0, PlaceholderType.AUDIENCE), new PlaceholderDefinition("homes", 0, PlaceholderType.AUDIENCE), new PlaceholderDefinition("set_max", 0, PlaceholderType.AUDIENCE), new PlaceholderDefinition("numberofhomes_limit", 0, PlaceholderType.AUDIENCE), new PlaceholderDefinition("has_home", 1, PlaceholderType.AUDIENCE), new PlaceholderDefinition("home", 1, PlaceholderType.AUDIENCE), new PlaceholderDefinition("home_world", 1, PlaceholderType.AUDIENCE), new PlaceholderDefinition("home_x", 2, PlaceholderType.AUDIENCE), new PlaceholderDefinition("home_y", 2, PlaceholderType.AUDIENCE), new PlaceholderDefinition("home_z", 2, PlaceholderType.AUDIENCE), new PlaceholderDefinition("home_pitch", 2, PlaceholderType.AUDIENCE), new PlaceholderDefinition("home_yaw", 2, PlaceholderType.AUDIENCE), new PlaceholderDefinition("p_set", 0, PlaceholderType.PLAYER_TARGETED), new PlaceholderDefinition("p_numberofhomes", 0, PlaceholderType.PLAYER_TARGETED), new PlaceholderDefinition("p_limit", 0, PlaceholderType.PLAYER_TARGETED), new PlaceholderDefinition("p_max", 0, PlaceholderType.PLAYER_TARGETED), new PlaceholderDefinition("p_homes", 0, PlaceholderType.PLAYER_TARGETED), new PlaceholderDefinition("p_set_max", 0, PlaceholderType.PLAYER_TARGETED), new PlaceholderDefinition("p_numberofhomes_limit", 0, PlaceholderType.PLAYER_TARGETED), new PlaceholderDefinition("p_has_home", 1, PlaceholderType.PLAYER_TARGETED), new PlaceholderDefinition("p_home", 1, PlaceholderType.PLAYER_TARGETED), new PlaceholderDefinition("p_home_world", 1, PlaceholderType.PLAYER_TARGETED), new PlaceholderDefinition("p_home_x", 2, PlaceholderType.PLAYER_TARGETED), new PlaceholderDefinition("p_home_y", 2, PlaceholderType.PLAYER_TARGETED), new PlaceholderDefinition("p_home_z", 2, PlaceholderType.PLAYER_TARGETED), new PlaceholderDefinition("p_home_pitch", 2, PlaceholderType.PLAYER_TARGETED), new PlaceholderDefinition("p_home_yaw", 2, PlaceholderType.PLAYER_TARGETED));
    }

    @Override
    @Nullable
    public String onPlaceholderRequest(@Nullable OfflinePlayer player, @NotNull String key, @NotNull List<String> parameters) {
        String resolvedKey;
        switch (resolvedKey = key.startsWith("p_") ? key.substring(2) : key) {
            case "version": {
                return zHomes.getInstance().getPluginMeta().getVersion();
            }
            case "numberofhomes": 
            case "set": {
                return player == null ? "0" : String.valueOf(HomesUtils.numberOfHomes(player));
            }
            case "limit": 
            case "max": {
                if (!zHomes.getConfigYAML().isLimitsEnabled()) {
                    return "Infinite";
                }
                return player == null ? "0" : String.valueOf(HomesUtils.getMaxLimit(player));
            }
            case "homes": {
                return player == null ? "" : HomesUtils.homes(player);
            }
            case "set_max": 
            case "numberofhomes_limit": {
                if (!zHomes.getConfigYAML().isLimitsEnabled()) {
                    return "Disabled";
                }
                return player == null ? "" : HomesUtils.numberOfHomes(player) + "/" + HomesUtils.getMaxLimit(player);
            }
            case "has_home": {
                if (player == null || parameters.isEmpty()) {
                    return "false";
                }
                return String.valueOf(HomesUtils.hasHome(player, parameters.get(0)));
            }
            case "home": {
                if (player == null || parameters.isEmpty()) {
                    return "";
                }
                return this.getHomeNameByIndex(player, parameters.get(0));
            }
            case "home_world": 
            case "home_x": 
            case "home_y": 
            case "home_z": 
            case "home_pitch": 
            case "home_yaw": {
                if (player == null || parameters.isEmpty()) {
                    return "";
                }
                String coordinate = resolvedKey.substring("home_".length());
                String id = parameters.get(0);
                String format = parameters.size() > 1 ? parameters.get(1) : null;
                return this.getHomeCoordinate(player, id, coordinate, format);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String applyHookPlaceholders(@Nullable OfflinePlayer player, @NotNull String params) {
        boolean addName = false;
        if (params.startsWith("addname_")) {
            addName = true;
            params = params.substring(8);
        }
        String[] split = params.split("_");
        switch (params) {
            case "version": {
                return this.onPlaceholderRequest(player, "version", Collections.emptyList());
            }
            case "numberofhomes": 
            case "set": {
                return this.onPlaceholderRequest(player, params, Collections.emptyList());
            }
            case "limit": 
            case "max": {
                return this.onPlaceholderRequest(player, params, Collections.emptyList());
            }
            case "homes": {
                return this.onPlaceholderRequest(player, "homes", Collections.emptyList());
            }
            case "numberofhomes/limit": {
                return this.onPlaceholderRequest(player, "numberofhomes_limit", Collections.emptyList());
            }
            case "set/max": {
                return this.onPlaceholderRequest(player, "set_max", Collections.emptyList());
            }
        }
        if (params.startsWith("has_home") || params.startsWith("hashome")) {
            String homeName = split[split.length - 1];
            return this.onPlaceholderRequest(player, "has_home", List.of(homeName));
        }
        if (params.startsWith("home")) {
            if (player == null || split.length < 2 || !TextFormatter.isInteger(split[1])) {
                return "";
            }
            String id = split[1];
            if (split.length >= 3) {
                String coordinate = split[2];
                String format = split.length == 4 ? split[3] : null;
                String key = "home_" + coordinate;
                List<String> args = format != null ? List.of(id, format) : List.of(id);
                String result = this.onPlaceholderRequest(player, key, args);
                return result != null ? result : "";
            }
            String homeName = this.getHomeNameByIndex(player, id);
            if (homeName == null || homeName.isEmpty()) {
                return "";
            }
            return addName ? player.getName() + ":" + homeName : homeName;
        }
        if (split.length >= 2) {
            String tName = split[0];
            if (player != null && tName.equals(player.getName())) {
                return this.applyPlaceholders(player, "%" + this.getIdentifier() + "_" + params.substring(tName.length() + 1) + "%");
            }
            OfflinePlayer t = PlayerHandler.getOfflinePlayer(tName);
            if (t == null) {
                return "";
            }
            return this.applyPlaceholders(t, "%" + this.getIdentifier() + "_addname_" + params.substring(tName.length() + 1) + "%");
        }
        return "";
    }

    @Nullable
    private String getHomeNameByIndex(@NotNull OfflinePlayer player, @NotNull String idStr) {
        List<String> homes;
        if (!TextFormatter.isInteger(idStr)) {
            return null;
        }
        int id = Integer.parseInt(idStr);
        if (id > (homes = HomesUtils.getHomes(player)).size() || id < 1) {
            return null;
        }
        return homes.get(id - 1);
    }

    @Nullable
    private String getHomeCoordinate(@NotNull OfflinePlayer player, @NotNull String idStr, @NotNull String coordinate, @Nullable String format) {
        String homeName = this.getHomeNameByIndex(player, idStr);
        if (homeName == null) {
            return null;
        }
        Location loc = HomesUtils.getHomeLoc(player, homeName);
        if (loc == null) {
            return null;
        }
        return switch (coordinate) {
            case "w", "world" -> Objects.requireNonNull(loc.getWorld()).getName();
            case "x" -> this.getParsedDouble(format, loc.getX());
            case "y" -> this.getParsedDouble(format, loc.getY());
            case "z" -> this.getParsedDouble(format, loc.getZ());
            case "pitch" -> this.getParsedDouble(format, loc.getPitch());
            case "yaw" -> this.getParsedDouble(format, loc.getYaw());
            default -> null;
        };
    }

    public String getParsedDouble(@Nullable String format, double d) {
        DecimalFormat df = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
        if (format == null) {
            return df.format(d);
        }
        if (format.equals("full")) {
            return String.valueOf(d);
        }
        if (!TextFormatter.isInteger(format)) {
            return df.format(d);
        }
        int decimals = Integer.parseInt(format);
        if (decimals >= 15) {
            decimals = 14;
        }
        if (decimals < 0) {
            decimals = 0;
        }
        StringBuilder pattern = new StringBuilder("0");
        if (decimals > 0) {
            pattern.append(".");
            for (int i = 0; i < decimals; ++i) {
                pattern.append("#");
            }
        }
        df = new DecimalFormat(pattern.toString(), new DecimalFormatSymbols(Locale.US));
        return df.format(d);
    }

    public List<String> getPlaceholderSuggestions(String partial) {
        String withoutPercent = partial.substring(1);
        if (!withoutPercent.startsWith(this.getIdentifier()) || withoutPercent.equals(this.getIdentifier())) {
            return List.of("%" + this.getIdentifier() + "_");
        }
        if (withoutPercent.startsWith(this.getIdentifier() + "_")) {
            List<String> placeholders;
            List<String> suggestions;
            String afterIdentifier = withoutPercent.substring(this.getIdentifier().length() + 1);
            String[] parts = afterIdentifier.split("_");
            if (parts.length >= 1) {
                boolean isPlayerName;
                String firstPart = parts[0];
                List<String> knownPlaceholders = Arrays.asList("version", "set", "limit", "max", "homes", "has", "hashome", "home");
                boolean bl = isPlayerName = !knownPlaceholders.contains(firstPart) && !firstPart.isEmpty() && !firstPart.startsWith("<");
                if (isPlayerName) {
                    List<String> playerPlaceholders;
                    List<String> suggestions2;
                    String[] playerParts;
                    String afterPlayer = parts.length > 1 ? afterIdentifier.substring(firstPart.length() + 1) : "";
                    String[] stringArray = playerParts = afterPlayer.isEmpty() ? new String[]{} : afterPlayer.split("_");
                    if (playerParts.length >= 2 && playerParts[0].equals("home") && TextFormatter.isInteger(playerParts[1])) {
                        if (playerParts.length == 2 || playerParts.length == 3 && !playerParts[2].isEmpty()) {
                            String currentPart = playerParts.length == 3 ? playerParts[2] : "";
                            List<String> coordinateOptions = Arrays.asList("world", "x", "y", "z", "pitch", "yaw");
                            List<String> suggestions3 = coordinateOptions.stream().filter(opt -> opt.startsWith(currentPart)).map(opt -> "%" + this.getIdentifier() + "_" + firstPart + "_home_" + playerParts[1] + "_" + opt + "%").toList();
                            return suggestions3.isEmpty() ? List.of() : suggestions3;
                        }
                        if (playerParts.length == 4 && (playerParts[2].equals("x") || playerParts[2].equals("y") || playerParts[2].equals("z") || playerParts[2].equals("pitch") || playerParts[2].equals("yaw"))) {
                            List<String> formatOptions = Arrays.asList("0", "1", "2", "3", "full");
                            return formatOptions.stream().map(fmt -> "%" + this.getIdentifier() + "_" + firstPart + "_home_" + playerParts[1] + "_" + playerParts[2] + "_" + fmt + "%").toList();
                        }
                        if (playerParts.length >= 5) {
                            return List.of();
                        }
                    }
                    return (suggestions2 = (playerPlaceholders = Arrays.asList("version", "set", "limit", "max", "homes", "set/max", "has_home_<name>", "hashome_<name>", "home_<id>", "home_<id>_world", "home_<id>_x", "home_<id>_y", "home_<id>_z", "home_<id>_pitch", "home_<id>_yaw", "home_<id>_x_<format>", "home_<id>_y_<format>", "home_<id>_z_<format>")).stream().filter(p -> p.startsWith(afterPlayer)).map(p -> "%" + this.getIdentifier() + "_" + firstPart + "_" + p + "%").toList()).isEmpty() ? List.of() : suggestions2;
                }
            }
            if (parts.length >= 2 && parts[0].equals("home") && TextFormatter.isInteger(parts[1])) {
                if (parts.length == 2 || parts.length == 3 && !parts[2].isEmpty()) {
                    String currentPart = parts.length == 3 ? parts[2] : "";
                    List<String> coordinateOptions = Arrays.asList("world", "x", "y", "z", "pitch", "yaw");
                    List<String> suggestions4 = coordinateOptions.stream().filter(opt -> opt.startsWith(currentPart)).map(opt -> "%" + this.getIdentifier() + "_" + parts[0] + "_" + parts[1] + "_" + opt + "%").toList();
                    return suggestions4.isEmpty() ? List.of() : suggestions4;
                }
                if (parts.length == 4 && (parts[2].equals("x") || parts[2].equals("y") || parts[2].equals("z") || parts[2].equals("pitch") || parts[2].equals("yaw"))) {
                    List<String> formatOptions = Arrays.asList("0", "1", "2", "3", "full");
                    return formatOptions.stream().map(fmt -> "%" + this.getIdentifier() + "_" + parts[0] + "_" + parts[1] + "_" + parts[2] + "_" + fmt + "%").toList();
                }
                if (parts.length >= 5) {
                    return List.of();
                }
            }
            return (suggestions = (placeholders = Arrays.asList("version", "set", "limit", "max", "homes", "set/max", "has_home_<name>", "hashome_<name>", "home_<id>", "home_<id>_world", "home_<id>_x", "home_<id>_y", "home_<id>_z", "home_<id>_pitch", "home_<id>_yaw", "home_<id>_x_<format>", "home_<id>_y_<format>", "home_<id>_z_<format>", "<player>_<placeholder>")).stream().filter(p -> p.startsWith(afterIdentifier)).map(p -> "%" + this.getIdentifier() + "_" + p + "%").toList()).isEmpty() ? List.of() : suggestions;
        }
        return List.of();
    }
}

