/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.configuration.languages;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.yleoft.zHomes.libs.zAPI.configuration.YAMLBuilder;
import me.yleoft.zHomes.libs.zAPI.hooks.HookRegistry;
import me.yleoft.zHomes.libs.zAPI.utility.TextFormatter;
import me.yleoft.zHomes.storage.DatabaseEditor;
import me.yleoft.zHomes.utility.HomesUtils;
import me.yleoft.zHomes.zHomes;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class LanguageBuilder
extends YAMLBuilder {
    private static final String currentVersion = "1.0.1";
    private static final File languageFolder = new File(zHomes.getInstance().getDataFolder(), "languages");

    protected Map<String, String> translations() {
        HashMap<String, String> t = new HashMap<String, String>();
        t.put(LanguageBuilder.formPath("config", "comment", "header1"), "# |                                   Plugin links & support                                     | #");
        t.put(LanguageBuilder.formPath("config", "comment", "header2"), "# |   zHomes (c) yL3oft \u2014 released under the MIT License.                                        | #");
        t.put(LanguageBuilder.formPath("config", "comment", "database"), "Edit your database settings below");
        t.put(LanguageBuilder.formPath("config", "comment", "database", "type"), "Here you can define how to store the plugin data.\nOPTIONS:\n- H2 (Preferred over SQLite)\n- SQLite\n- MariaDB (Preferred over MySQL)\n- MySQL\nDEFAULT: H2\n");
        t.put(LanguageBuilder.formPath("config", "comment", "pool-size"), "# WARNING: DO NOT CHANGE ANYTHING BELOW IF YOU DON'T KNOW WHAT YOU'RE DOING");
        t.put(LanguageBuilder.formPath("config", "comment", "general", "language"), "Here you can define the language of the plugin, all languages can be found, edited and created on languages' directory.\nCURRENTLY AVAILABLE LANGUAGES: [de, en, es, fr, it, nl, pl, pt-br, ru, zhcn, <custom>]\n");
        t.put(LanguageBuilder.formPath("config", "comment", "general", "announce-update"), "Toggle whether the plugin should announce available updates in the console and to players with the appropriate permission.");
        t.put(LanguageBuilder.formPath("config", "comment", "general", "metrics"), "Enable or disable metrics collection to help improve the plugin.\nAll data collected is anonymous and used solely for statistical purposes.\n!WARNING: Requires server restart to take effect!\n");
        t.put(LanguageBuilder.formPath("config", "comment", "general", "debug-mode"), "Enable or disable debug mode for more detailed logging output.");
        t.put(LanguageBuilder.formPath("config", "comment", "teleport-options"), "Settings related to teleportation behavior");
        t.put(LanguageBuilder.formPath("config", "comment", "teleport-options", "enable-safe-teleport"), "Enable or disable safe teleportation to prevent players from being teleported into dangerous locations.");
        t.put(LanguageBuilder.formPath("config", "comment", "teleport-options", "dimensional-teleportation"), "Enable or disable dimensional teleportation, allowing players to teleport between different worlds or dimensions.");
        t.put(LanguageBuilder.formPath("config", "comment", "teleport-options", "play-sound"), "Play a sound effect when a player is teleported.");
        t.put(LanguageBuilder.formPath("config", "comment", "teleport-options", "restricted-worlds", "enable"), "Enable or disable the restriction of teleportation to certain worlds.");
        t.put(LanguageBuilder.formPath("config", "comment", "teleport-options", "restricted-worlds", "mode"), "Define the mode for restricted worlds.\nOPTIONS:\n- blacklist: Players cannot teleport to worlds listed below.\n- whitelist: Players can only teleport to worlds listed below.\n");
        t.put(LanguageBuilder.formPath("config", "comment", "teleport-options", "restricted-worlds", "worlds"), "List of worlds affected by the restricted worlds setting.");
        t.put(LanguageBuilder.formPath("config", "comment", "teleport-options", "warmup", "enable"), "Enable or disable teleportation warmup period.");
        t.put(LanguageBuilder.formPath("config", "comment", "teleport-options", "warmup", "time"), "Define the warmup time in seconds before teleportation occurs.");
        t.put(LanguageBuilder.formPath("config", "comment", "teleport-options", "warmup", "cancel-on-move"), "Cancel the teleportation if the player moves during the warmup period.");
        t.put(LanguageBuilder.formPath("config", "comment", "teleport-options", "warmup", "show-on-actionbar"), "Show warmup countdown on the action bar.");
        t.put(LanguageBuilder.formPath("config", "comment", "limits", "enabled"), "Enable or disable home limits for players.");
        t.put(LanguageBuilder.formPath("config", "comment", "limits", "default"), "Default number of homes a player can set.");
        t.put(LanguageBuilder.formPath("config", "comment", "limits", "examples"), "Limit examples based on player groups.");
        t.put(LanguageBuilder.formPath("config", "comment", "commands"), "!WARNING: Mostly everything below needs a restart to apply.");
        t.put(LanguageBuilder.formPath("config", "comment", "commands", "command-cost"), "command-cost requires Vault to work.");
        t.put(LanguageBuilder.formPath("config", "comment", "commands", "homes", "types"), "Define how the homes will be displayed to the player.\nOPTIONS:\n- text: Displays homes in a simple list format.\n- menu: Opens a graphical menu to select homes.\n");
        t.put(LanguageBuilder.formPath("config", "comment", "permissions"), "Permission nodes used by the plugin");
        t.put(LanguageBuilder.formPath("config", "comment", "permissions", "bypass", "limit"), "Permission to bypass home limits");
        t.put(LanguageBuilder.formPath("config", "comment", "permissions", "bypass", "dimensional-teleportation"), "Permission to bypass dimensional teleportation restrictions");
        t.put(LanguageBuilder.formPath("config", "comment", "permissions", "bypass", "safe-teleportation"), "Permission to bypass safe teleportation checks");
        t.put(LanguageBuilder.formPath("config", "comment", "permissions", "bypass", "restricted-worlds"), "Permission to bypass restricted worlds checks");
        t.put(LanguageBuilder.formPath("config", "comment", "permissions", "bypass", "warmup"), "Permission to bypass teleportation warmup");
        t.put(LanguageBuilder.formPath("config", "comment", "permissions", "bypass", "command-costs"), "Permission to bypass command costs");
        t.put(LanguageBuilder.formPath("config", "comment", "permissions", "bypass", "command-cooldowns"), "Permission to bypass command cooldowns");
        return t;
    }

    public LanguageBuilder(String langFileName) {
        super(new File(languageFolder, langFileName + ".yml"));
        this.migrateLegacyColors(true);
        this.buildLang();
    }

    public void buildLang() {
        this.header(this.t("header", "####################################################################################################\n# +----------------------------------------------------------------------------------------------+ #\n# |                                                                                              | #\n# |                                   zHomes \u2014 Language File                                     | #\n# |                                                                                              | #\n# |   \u2022 Wiki:        https://docs.yleoft.me/zhomes                                               | #\n# |   \u2022 Discord:     https://discord.gg/yCdhVDgn4K                                               | #\n# |   \u2022 GitHub:      https://github.com/yL3oft/zHomes                                            | #\n# |                                                                                              | #\n# +----------------------------------------------------------------------------------------------+ #\n####################################################################################################\n"));
        if (this.versionOlder(currentVersion)) {
            this.voidPath(LanguageBuilder.formPath("commands", "main", "version", "update"));
            this.updateVersion(currentVersion);
        }
        this.commentSection("hooks", this.t(LanguageBuilder.formPath("comments", "hooks"), "Here you can manage hook messages."));
        this.addDefault(LanguageBuilder.formPath("hooks", "griefprevention", "cant-set-homes"), this.t(LanguageBuilder.formPath("hooks", "griefprevention", "cant-set-homes"), "%prefix% <red>You can't set homes in this area."));
        this.addDefault(LanguageBuilder.formPath("hooks", "worldguard", "cant-use-homes"), this.t(LanguageBuilder.formPath("hooks", "worldguard", "cant-use-homes"), "%prefix% <red>You can't use homes here."));
        this.addDefault(LanguageBuilder.formPath("hooks", "worldguard", "cant-set-homes"), this.t(LanguageBuilder.formPath("hooks", "worldguard", "cant-set-homes"), "%prefix% <red>You can't set a home here."));
        this.addDefault(LanguageBuilder.formPath("hooks", "vault", "cant-afford-command"), this.t(LanguageBuilder.formPath("hooks", "vault", "cant-afford-command"), "%prefix% <red>You need <gold>$%cost% <red>in order to execute this command."));
        this.commentSection("teleport-warmup", this.t(LanguageBuilder.formPath("comments", "teleport-warmup"), "Messages related to teleport warmup."));
        this.addDefault(LanguageBuilder.formPath("teleport-warmup", "warmup"), this.t(LanguageBuilder.formPath("teleport-warmup", "warmup"), "%prefix% <green>Teleporting in %time% seconds... Don't move!"));
        this.addDefault(LanguageBuilder.formPath("teleport-warmup", "warmup-actionbar"), this.t(LanguageBuilder.formPath("teleport-warmup", "warmup-actionbar"), "<green>Teleporting in %time% seconds..."));
        this.addDefault(LanguageBuilder.formPath("teleport-warmup", "cancelled"), this.t(LanguageBuilder.formPath("teleport-warmup", "cancelled"), "%prefix% <red>You moved! Teleportation cancelled."));
        this.addDefault(LanguageBuilder.formPath("teleport-warmup", "cancelled-actionbar"), this.t(LanguageBuilder.formPath("teleport-warmup", "cancelled-actionbar"), "<red>You moved! Teleportation cancelled."));
        this.commentSection("commands", this.t(LanguageBuilder.formPath("comments", "commands"), "Messages related to commands."));
        this.comment(false, this.t(LanguageBuilder.formPath("comments", "commands", "no-permission"), "Up here you will find messages that can be used in multiple commands."));
        this.addDefault(LanguageBuilder.formPath("commands", "no-permission"), this.t(LanguageBuilder.formPath("commands", "no-permission"), "%prefix% <red>You don't have permission to execute this command."));
        this.addDefault(LanguageBuilder.formPath("commands", "only-players"), this.t(LanguageBuilder.formPath("commands", "only-players"), "%prefix% <red>Only players can execute this command."));
        this.addDefault(LanguageBuilder.formPath("commands", "in-cooldown"), this.t(LanguageBuilder.formPath("commands", "in-cooldown"), "%prefix% <red>You must wait %time% seconds before using this command again."));
        this.addDefault(LanguageBuilder.formPath("commands", "home-already-exist"), this.t(LanguageBuilder.formPath("commands", "home-already-exist"), "%prefix% <red>You already have a home with this name."));
        this.addDefault(LanguageBuilder.formPath("commands", "home-doesnt-exist"), this.t(LanguageBuilder.formPath("commands", "home-doesnt-exist"), "%prefix% <red>You don't have any home with this name."));
        this.addDefault(LanguageBuilder.formPath("commands", "home-doesnt-exist-others"), this.t(LanguageBuilder.formPath("commands", "home-doesnt-exist-others"), "%prefix% <yellow>%player% <red>don't have any home with this name."));
        this.addDefault(LanguageBuilder.formPath("commands", "cant-use-2dot"), this.t(LanguageBuilder.formPath("commands", "cant-use-2dot"), "%prefix% <red>You can't use <yellow>':' <red>in this command."));
        this.addDefault(LanguageBuilder.formPath("commands", "cant-find-player"), this.t(LanguageBuilder.formPath("commands", "cant-find-player"), "%prefix% <red>This player was not found."));
        this.addDefault(LanguageBuilder.formPath("commands", "unable-to-find-safe-location"), this.t(LanguageBuilder.formPath("commands", "unable-to-find-safe-location"), "%prefix% <red>Unable to find a safe location to teleport you."));
        this.addDefault(LanguageBuilder.formPath("commands", "world-restricted-sethome"), this.t(LanguageBuilder.formPath("commands", "world-restricted-sethome"), "%prefix% <red>You can't set homes in this world."));
        this.addDefault(LanguageBuilder.formPath("commands", "world-restricted-home"), this.t(LanguageBuilder.formPath("commands", "world-restricted-home"), "%prefix% <red>You can't teleport to homes in that world."));
        this.commentSection(LanguageBuilder.formPath("commands", "main"), this.t(LanguageBuilder.formPath("comments", "commands", "main"), "Below you will find messages specific for the commands."));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "help", "help-perm"), this.t(LanguageBuilder.formPath("commands", "main", "help", "help-perm"), "%prefix% <aqua>Usages of <yellow>/%command%<aqua>:\n<red>-> <yellow>/%command% <green>help <gray>Shows this exact help message\n<red>-> <yellow>/%command% <green>info <gray>Shows plugin information\n<red>-> <yellow>/%command% <green>(reload|rl) <gold>[all, commands, config, languages]\n<red>-> <yellow>/%command% <green>(version|ver) <gray>Shows plugin version\n<red>-> <yellow>/%command% <green>nearhomes (radius) <gray>List homes near you within a certain radius\n<red>-> <yellow>/%command% <green>parse (Player) (String) <gray>Parses a string with placeholders for a specific player\n<red>-> <yellow>/%command% <green>purge (<player>|*) <gold>[-world] [-startwith] [-endwith] [-player] <gray>Purge homes with filters\n<red>-> <yellow>/%command% <green>converter (<converter-type>) <gray>Convert data from one place to another\n<red>-> <yellow>/%command% <green>export <gray>Exports all homes to a single file\n<red>-> <yellow>/%command% <green>import (<file>) <gray>Imports homes from a single file\n"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "help", "help-noperm"), this.t(LanguageBuilder.formPath("commands", "main", "help", "help-noperm"), "%prefix% <aqua>Usages of <yellow>/%command%<aqua>:\n<red>-> <yellow>/%command% <green>(help|?) <gray>Shows this exact help message\n<red>-> <yellow>/%command% <green>(version|ver) <gray>Shows plugin version\n"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "info", "output"), this.t(LanguageBuilder.formPath("commands", "main", "info", "output"), "%prefix% <aqua>Running <dark_aqua>%name% v%version% <aqua>by <dark_aqua>%author%<aqua>:\n%prefix% <aqua>- Server Info:\n%prefix% <dark_aqua>   Software: <white>%server.software%\n%prefix% <dark_aqua>   Version: <white>%server.version%\n%prefix% <dark_aqua>   Require update: <white>%requpdate%\n%prefix% <dark_aqua>   Language: <white>%language%\n%prefix% <aqua>- Storage:\n%prefix% <dark_aqua>   Type: <white>%storage.type%\n%prefix% <dark_aqua>   Users: <white>%storage.users%\n%prefix% <dark_aqua>   Homes: <white>%storage.homes%\n%prefix% <aqua>- Hooks:\n%prefix% <dark_aqua>   PlaceholderAPI: <white>%use.placeholderapi%\n%prefix% <dark_aqua>   MiniPlaceholders: <white>%use.miniplaceholders%\n%prefix% <dark_aqua>   GriefPrevention: <white>%use.griefprevention%\n%prefix% <dark_aqua>   WorldGuard: <white>%use.worldguard%\n%prefix% <dark_aqua>   Vault: <white>%use.vault%\n"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "info", "requpdate-yes"), this.t(LanguageBuilder.formPath("commands", "main", "info", "requpdate-yes"), "<red>Yes <gray>(Use <yellow>/%command% version <gray>for more info)"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "info", "requpdate-no"), this.t(LanguageBuilder.formPath("commands", "main", "info", "requpdate-no"), "<green>No"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "version", "output"), this.t(LanguageBuilder.formPath("commands", "main", "version", "output"), "%prefix% <aqua>Current version: <green>%version%\n%prefix% <green>You are already using the latest version of zHomes.\n"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "reload", "usage"), this.t(LanguageBuilder.formPath("commands", "main", "reload", "usage"), "%prefix% <aqua>Usages of <yellow>/%command% <green>(reload|rl)<aqua>:\n<red>-> <yellow>/%command% <green>(reload|rl) <gold>[all, commands, config, languages]\n"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "reload", "output"), this.t(LanguageBuilder.formPath("commands", "main", "reload", "output"), "%prefix% <green>Reloaded plugin in <aqua>%time%ms<green>."));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "reload", "commands", "output"), this.t(LanguageBuilder.formPath("commands", "main", "reload", "commands", "output"), "%prefix% <green>Reloaded all plugin commands in <aqua>%time%ms<green>."));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "reload", "config", "output"), this.t(LanguageBuilder.formPath("commands", "main", "reload", "config", "output"), "%prefix% <green>Reloaded plugin config file in <aqua>%time%ms<green>."));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "reload", "languages", "output"), this.t(LanguageBuilder.formPath("commands", "main", "reload", "languages", "output"), "%prefix% <green>Reloaded plugin languages in <aqua>%time%ms<green>."));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "nearhomes", "usage"), this.t(LanguageBuilder.formPath("commands", "main", "nearhomes", "usage"), "<red>-> <yellow>/%command% nearhomes <green>[<Radius>]"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "nearhomes", "output"), this.t(LanguageBuilder.formPath("commands", "main", "nearhomes", "output"), "%prefix% <gray>Homes near you within <yellow>%radius% <gray>blocks: <white>%homes%"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "nearhomes", "output-not-found"), this.t(LanguageBuilder.formPath("commands", "main", "nearhomes", "output-not-found"), "%prefix% <red>No homes found within <yellow>%radius% <red>blocks."));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "nearhomes", "home-string"), this.t(LanguageBuilder.formPath("commands", "main", "nearhomes", "home-string"), "<yellow><hover:show_text:'<green>Click to teleport.'><click:run_command:'/%homecommand% %owner%:%home%'>%home%</click></hover> <gray><hover:show_text:'<green>Click to filter search for player.'><click:run_command:'/%maincommand% nearhomes %radius% -user %owner%'>(%owner%)</click></hover>"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "nearhomes", "filtered-player", "output"), this.t(LanguageBuilder.formPath("commands", "main", "nearhomes", "filtered-player", "output"), "%prefix% <gray>Homes of <yellow>%player% <gray>near you within <yellow>%radius% <gray>blocks: <white>%homes%"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "nearhomes", "filtered-player", "home-string"), this.t(LanguageBuilder.formPath("commands", "main", "nearhomes", "filtered-player", "home-string"), "<yellow><hover:show_text:'<green>Click to teleport.'><click:run_command:'/%homecommand% %player%:%home%'>%home%</click></hover>"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "parse", "usage"), this.t(LanguageBuilder.formPath("commands", "main", "parse", "usage"), "<red>-> <yellow>/%command% parse <gold>(Player) (String)"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "parse", "output"), this.t(LanguageBuilder.formPath("commands", "main", "parse", "output"), "%prefix% <gray>Parsed text: <white>%parsed%"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "purge", "usage"), this.t(LanguageBuilder.formPath("commands", "main", "purge", "usage"), "%prefix% <aqua>Usages of <yellow>/%command% purge<aqua>:\n<red>-> <yellow>/%command% purge <green>(<player>|*) <gray>Purge all homes for a player or everyone\n<red>-> <yellow>/%command% purge <green>(<player>|*) <gold>-world <green>(world) <gray>Purge homes in a specific world\n<red>-> <yellow>/%command% purge <green>(<player>|*) <gold>-startwith <green>(prefix) <gray>Purge homes starting with prefix\n<red>-> <yellow>/%command% purge <green>(<player>|*) <gold>-endwith <green>(suffix) <gray>Purge homes ending with suffix\n<red>-> <yellow>/%command% purge <green>* <gold>-player <green>(players) <gray>Purge homes only for specific players\n<aqua>You can combine multiple filters:\n<red>-> <yellow>/%command% purge <green>* <gold>-world <green>world_nether <gold>-startwith <green>temp_\n<red>-> <yellow>/%command% purge <green>PlayerName <gold>-world <green>world_the_end <gold>-endwith <green>_old\n"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "purge", "output"), this.t(LanguageBuilder.formPath("commands", "main", "purge", "output"), "%prefix% <green>Successfully purged <yellow>%amount% <green>home(s)!"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "converter", "usage"), this.t(LanguageBuilder.formPath("commands", "main", "converter", "usage"), "%prefix% <aqua>Usages of <yellow>/%command% <green>converter<aqua>:\n<red>-> <yellow>/%command% <green>converter sqlitetoh2\n<red>-> <yellow>/%command% <green>converter sqlitetomysql\n<red>-> <yellow>/%command% <green>converter sqlitetomariadb\n<red>-> <yellow>/%command% <green>converter mysqltosqlite\n<red>-> <yellow>/%command% <green>converter mysqltoh2\n<red>-> <yellow>/%command% <green>converter mariadbtosqlite\n<red>-> <yellow>/%command% <green>converter mariadbtoh2\n<red>-> <yellow>/%command% <green>converter h2tosqlite\n<red>-> <yellow>/%command% <green>converter h2tomysql\n<red>-> <yellow>/%command% <green>converter h2tomariadb\n<red>-> <yellow>/%command% <green>converter essentials\n<red>-> <yellow>/%command% <green>converter sethome\n<red>-> <yellow>/%command% <green>converter ultimatehomes\n<red>-> <yellow>/%command% <green>converter xhomes\n<red>-> <yellow>/%command% <green>converter zhome\n"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "converter", "output"), this.t(LanguageBuilder.formPath("commands", "main", "converter", "output"), "%prefix% <green>All data converted!"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "converter", "error"), this.t(LanguageBuilder.formPath("commands", "main", "converter", "error"), "%prefix% <red>Something went wrong converting the data, please check your server console."));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "export", "output"), this.t(LanguageBuilder.formPath("commands", "main", "export", "output"), "%prefix% <green>All homes exported to <yellow>%file%<green>!"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "export", "error"), this.t(LanguageBuilder.formPath("commands", "main", "export", "error"), "%prefix% <red>Something went wrong exporting the data, please check your server console."));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "import", "usage"), this.t(LanguageBuilder.formPath("commands", "main", "import", "usage"), "<red>-> <yellow>/%command% import <green>(<file>)"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "import", "output"), this.t(LanguageBuilder.formPath("commands", "main", "import", "output"), "%prefix% <green>All homes imported from <yellow>%file%<green>!"));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "import", "file-not-found"), this.t(LanguageBuilder.formPath("commands", "main", "import", "file-not-found"), "%prefix% <red>The file <yellow>%file% <red>was not found."));
        this.addDefault(LanguageBuilder.formPath("commands", "main", "import", "error"), this.t(LanguageBuilder.formPath("commands", "main", "import", "error"), "%prefix% <red>Something went wrong importing the data, please check your server console."));
        this.addDefault(LanguageBuilder.formPath("commands", "sethome", "usage"), this.t(LanguageBuilder.formPath("commands", "sethome", "usage"), "<red>-> <yellow>/%command% <green>(Home)"));
        this.addDefault(LanguageBuilder.formPath("commands", "sethome", "output"), this.t(LanguageBuilder.formPath("commands", "sethome", "output"), "%prefix% <green>Home <yellow>%home% <green>set to your position."));
        this.addDefault(LanguageBuilder.formPath("commands", "sethome", "limit-reached"), this.t(LanguageBuilder.formPath("commands", "sethome", "limit-reached"), "<red>You can't set more homes because you reached your limit <yellow>(%limit% homes)<red>!"));
        this.addDefault(LanguageBuilder.formPath("commands", "delhome", "usage"), this.t(LanguageBuilder.formPath("commands", "delhome", "usage"), "<red>-> <yellow>/%command% <green>(Home)"));
        this.addDefault(LanguageBuilder.formPath("commands", "delhome", "output"), this.t(LanguageBuilder.formPath("commands", "delhome", "output"), "%prefix% <red>Home <yellow>%home% <red>deleted."));
        this.addDefault(LanguageBuilder.formPath("commands", "home", "usage"), this.t(LanguageBuilder.formPath("commands", "home", "usage"), "<red>-> <yellow>/%command% <green>(Home)"));
        this.addDefault(LanguageBuilder.formPath("commands", "home", "output"), this.t(LanguageBuilder.formPath("commands", "home", "output"), "%prefix% <green>Teleported to <yellow>%home%<green>..."));
        this.addDefault(LanguageBuilder.formPath("commands", "home", "cant-dimensional-teleport"), this.t(LanguageBuilder.formPath("commands", "home", "cant-dimensional-teleport"), "<red>Your teleport was cancelled! Dimensional teleportation is disabled."));
        this.addDefault(LanguageBuilder.formPath("commands", "home", "rename", "usage"), this.t(LanguageBuilder.formPath("commands", "home", "rename", "usage"), "<red>-> <yellow>/%command% <green>rename (Home) (NewName)"));
        this.addDefault(LanguageBuilder.formPath("commands", "home", "rename", "output"), this.t(LanguageBuilder.formPath("commands", "home", "rename", "output"), "%prefix% <green>Home <yellow>%home% <green>renamed to <yellow>%newname%<green>."));
        this.addDefault(LanguageBuilder.formPath("commands", "home", "rename", "same-name"), this.t(LanguageBuilder.formPath("commands", "home", "rename", "same-name"), "%prefix% <red>You can't rename a home to the same name."));
        this.addDefault(LanguageBuilder.formPath("commands", "homes", "output"), this.t(LanguageBuilder.formPath("commands", "homes", "output"), "%prefix% <gray>Your homes (%amount%): <white>%homes%"));
        this.addDefault(LanguageBuilder.formPath("commands", "homes", "home-string"), this.t(LanguageBuilder.formPath("commands", "homes", "home-string"), "<reset><hover:show_text:'<green>Click to teleport.'><click:run_command:'/%homecommand% %home%'>%home%</click></hover>"));
        this.addDefault(LanguageBuilder.formPath("commands", "homes", "invalid-page"), this.t(LanguageBuilder.formPath("commands", "homes", "invalid-page"), "%prefix% <red>Invalid page number! Please use a number higher than 0."));
        this.addDefault(LanguageBuilder.formPath("commands", "homes", "others", "output"), this.t(LanguageBuilder.formPath("commands", "homes", "others", "output"), "%prefix% <yellow>%player%'s <gray>homes (%amount%): <white>%homes%"));
        this.addDefault(LanguageBuilder.formPath("commands", "homes", "others", "home-string"), this.t(LanguageBuilder.formPath("commands", "homes", "others", "home-string"), "<reset><hover:show_text:'<green>Click to teleport.'><click:run_command:'/%homecommand% %player%:%home%'>%home%</click></hover>"));
        this.footer("!!! DON'T TOUCH config-version UNLESS YOU KNOW EXACTLY WHAT YOU'RE DOING !!!");
        this.build();
    }

    public String getConfigCommentHeader1() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "header1"));
    }

    public String getConfigCommentHeader2() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "header2"));
    }

    public String getConfigCommentDatabase() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "database"));
    }

    public String getConfigCommentDatabaseType() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "database", "type"));
    }

    public String getConfigCommentPoolSize() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "pool-size"));
    }

    public String getConfigCommentGeneralLanguage() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "general", "language"));
    }

    public String getConfigCommentGeneralAnnounceUpdate() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "general", "announce-update"));
    }

    public String getConfigCommentGeneralMetrics() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "general", "metrics"));
    }

    public String getConfigCommentGeneralDebugMode() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "general", "debug-mode"));
    }

    public String getConfigCommentTeleportOptions() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "teleport-options"));
    }

    public String getConfigCommentTeleportOptionsEnableSafeTeleport() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "teleport-options", "enable-safe-teleport"));
    }

    public String getConfigCommentTeleportOptionsDimensionalTeleportation() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "teleport-options", "dimensional-teleportation"));
    }

    public String getConfigCommentTeleportOptionsPlaySound() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "teleport-options", "play-sound"));
    }

    public String getConfigCommentTeleportOptionsRestrictedWorldsEnable() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "teleport-options", "restricted-worlds", "enable"));
    }

    public String getConfigCommentTeleportOptionsRestrictedWorldsMode() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "teleport-options", "restricted-worlds", "mode"));
    }

    public String getConfigCommentTeleportOptionsRestrictedWorldsWorlds() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "teleport-options", "restricted-worlds", "worlds"));
    }

    public String getConfigCommentTeleportOptionsWarmupEnable() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "teleport-options", "warmup", "enable"));
    }

    public String getConfigCommentTeleportOptionsWarmupTime() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "teleport-options", "warmup", "time"));
    }

    public String getConfigCommentTeleportOptionsWarmupCancelOnMove() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "teleport-options", "warmup", "cancel-on-move"));
    }

    public String getConfigCommentTeleportOptionsWarmupShowOnActionbar() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "teleport-options", "warmup", "show-on-actionbar"));
    }

    public String getConfigCommentLimitsEnabled() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "limits", "enabled"));
    }

    public String getConfigCommentLimitsDefault() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "limits", "default"));
    }

    public String getConfigCommentLimitsExamples() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "limits", "examples"));
    }

    public String getConfigCommentCommands() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "commands"));
    }

    public String getConfigCommentCommandsCommandCost() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "commands", "command-cost"));
    }

    public String getConfigCommentCommandsHomesTypes() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "commands", "homes", "types"));
    }

    public String getConfigCommentPermissions() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "permissions"));
    }

    public String getConfigCommentPermissionsBypassLimit() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "permissions", "bypass", "limit"));
    }

    public String getConfigCommentPermissionsBypassDimensionalTeleportation() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "permissions", "bypass", "dimensional-teleportation"));
    }

    public String getConfigCommentPermissionsBypassSafeTeleportation() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "permissions", "bypass", "safe-teleportation"));
    }

    public String getConfigCommentPermissionsBypassRestrictedWorlds() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "permissions", "bypass", "restricted-worlds"));
    }

    public String getConfigCommentPermissionsBypassWarmup() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "permissions", "bypass", "warmup"));
    }

    public String getConfigCommentPermissionsBypassCommandCosts() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "permissions", "bypass", "command-costs"));
    }

    public String getConfigCommentPermissionsBypassCommandCooldowns() {
        return this.translations().get(LanguageBuilder.formPath("config", "comment", "permissions", "bypass", "command-cooldowns"));
    }

    public String getGFCantSetHomes() {
        return this.getString(LanguageBuilder.formPath("hooks", "griefprevention", "cant-set-homes"));
    }

    public String getWGCantUseHomes() {
        return this.getString(LanguageBuilder.formPath("hooks", "worldguard", "cant-use-homes"));
    }

    public String getWGCantSetHomes() {
        return this.getString(LanguageBuilder.formPath("hooks", "worldguard", "cant-set-homes"));
    }

    public String getVaultCantAffordCommand() {
        return this.getString(LanguageBuilder.formPath("hooks", "vault", "cant-afford-command"));
    }

    public String getWarmup(int time) {
        return this.getString(LanguageBuilder.formPath("teleport-warmup", "warmup")).replace("%time%", String.valueOf(time));
    }

    public String getWarmupActionbar(int time) {
        return this.getString(LanguageBuilder.formPath("teleport-warmup", "warmup-actionbar")).replace("%time%", String.valueOf(time));
    }

    public String getWarmupCancelled() {
        return this.getString(LanguageBuilder.formPath("teleport-warmup", "cancelled"));
    }

    public String getWarmupCancelledActionbar() {
        return this.getString(LanguageBuilder.formPath("teleport-warmup", "cancelled-actionbar"));
    }

    public String getNoPermission() {
        return this.getString(LanguageBuilder.formPath("commands", "no-permission"));
    }

    public String getOnlyPlayers() {
        return this.getString(LanguageBuilder.formPath("commands", "only-players"));
    }

    public String getInCooldown() {
        return this.getString(LanguageBuilder.formPath("commands", "in-cooldown"));
    }

    public String getHomeAlreadyExist() {
        return this.getString(LanguageBuilder.formPath("commands", "home-already-exist"));
    }

    public String getHomeDoesntExist() {
        return this.getString(LanguageBuilder.formPath("commands", "home-doesnt-exist"));
    }

    public String getHomeDoesntExistOthers(String player) {
        return this.getString(LanguageBuilder.formPath("commands", "home-doesnt-exist-others")).replace("%player%", player);
    }

    public String getCantUse2Dot() {
        return this.getString(LanguageBuilder.formPath("commands", "cant-use-2dot"));
    }

    public String getCantFindPlayer() {
        return this.getString(LanguageBuilder.formPath("commands", "cant-find-player"));
    }

    public String getUnableToFindSafeLocation() {
        return this.getString(LanguageBuilder.formPath("commands", "unable-to-find-safe-location"));
    }

    public String getWorldRestrictedSethome() {
        return this.getString(LanguageBuilder.formPath("commands", "world-restricted-sethome"));
    }

    public String getWorldRestrictedHome() {
        return this.getString(LanguageBuilder.formPath("commands", "world-restricted-home"));
    }

    public String getMainHelpPerm() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "help", "help-perm"));
    }

    public String getMainHelpNoPerm() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "help", "help-noperm"));
    }

    public String getMainInfoOutput() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "info", "output")).replace("%name%", zHomes.getInstance().getPluginMeta().getName()).replace("%version%", zHomes.getInstance().getPluginMeta().getVersion()).replace("%author%", String.join((CharSequence)", ", zHomes.getInstance().getPluginMeta().getAuthors())).replace("%server.software%", Bukkit.getServer().getName()).replace("%server.version%", Bukkit.getServer().getVersion() + " - " + Bukkit.getServer().getBukkitVersion()).replace("%requpdate%", zHomes.updateUtils.needsUpdate ? this.getRequireUpdateYes() : this.getRequireUpdateNo()).replace("%language%", zHomes.getConfigYAML().getLanguageCode()).replace("%storage.type%", zHomes.getConfigYAML().getDatabaseType()).replace("%storage.users%", String.valueOf(DatabaseEditor.getTotalUsers())).replace("%storage.homes%", String.valueOf(DatabaseEditor.getTotalHomes())).replace("%use.placeholderapi%", HookRegistry.PAPI.exists() ? "<green>Yes" : "<red>No").replace("%use.miniplaceholders%", HookRegistry.MINI_PLACEHOLDERS.exists() ? "<green>Yes" : "<red>No").replace("%use.griefprevention%", me.yleoft.zHomes.hooks.HookRegistry.GRIEF_PREVENTION.exists() ? "<green>Yes" : "<red>No").replace("%use.worldguard%", me.yleoft.zHomes.hooks.HookRegistry.WORLDGUARD.exists() ? "<green>Yes" : "<red>No").replace("%use.vault%", me.yleoft.zHomes.hooks.HookRegistry.VAULT.exists() ? "<green>Yes" : "<red>No");
    }

    public String getRequireUpdateYes() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "info", "requpdate-yes"));
    }

    public String getRequireUpdateNo() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "info", "requpdate-no"));
    }

    public String getMainVersionOutput() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "version", "output")).replace("%version%", zHomes.getInstance().getPluginMeta().getVersion());
    }

    public String getMainReloadUsage() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "reload", "usage"));
    }

    public String getMainReloadOutput(long time) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "reload", "output")).replace("%time%", String.valueOf(time));
    }

    public String getMainReloadCommandsOutput(long time) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "reload", "commands", "output")).replace("%time%", String.valueOf(time));
    }

    public String getMainReloadConfigOutput(long time) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "reload", "config", "output")).replace("%time%", String.valueOf(time));
    }

    public String getMainReloadLanguagesOutput(long time) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "reload", "languages", "output")).replace("%time%", String.valueOf(time));
    }

    public String getMainNearhomesUsage() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "nearhomes", "usage"));
    }

    public String getMainNearhomesOutput(double radius, HashMap<OfflinePlayer, List<String>> homes, @Nullable String playerName, @Nullable String homeName) {
        StringBuilder homesList = new StringBuilder();
        for (OfflinePlayer p : homes.keySet()) {
            if (playerName != null && p.getName() != null && !p.getName().equalsIgnoreCase(playerName)) continue;
            for (String home : homes.get(p)) {
                if (homeName != null && !home.startsWith(homeName)) continue;
                if (!homesList.toString().isEmpty()) {
                    homesList.append(", ");
                }
                homesList.append(playerName == null ? this.getNearhomesHomeString(p, home, radius) : this.getNearhomesFilteredPlayerHomeString(p, home, radius));
            }
        }
        if (homesList.toString().isEmpty()) {
            return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "nearhomes", "output-not-found")).replace("%radius%", String.valueOf(radius));
        }
        return playerName == null ? this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "nearhomes", "output")).replace("%radius%", String.valueOf(radius)).replace("%homes%", homesList.toString()) : this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "nearhomes", "filtered-player", "output")).replace("%radius%", String.valueOf(radius)).replace("%homes%", homesList.toString()).replace("%player%", playerName);
    }

    public String getMainNearhomesOutput(double radius, HashMap<OfflinePlayer, List<String>> homes) {
        return this.getMainNearhomesOutput(radius, homes, null, null);
    }

    public String getNearhomesHomeString(OfflinePlayer player, String home, double radius) {
        return this.getString(LanguageBuilder.formPath("commands", "main", "nearhomes", "home-string")).replace("%homecommand%", zHomes.getConfigYAML().getHomeCommand()).replace("%maincommand%", zHomes.getConfigYAML().getMainCommand()).replace("%radius%", String.valueOf(radius)).replace("%home%", home).replace("%owner%", player == null || player.getName() == null ? "----" : player.getName());
    }

    public String getNearhomesFilteredPlayerHomeString(OfflinePlayer player, String home, double radius) {
        return this.getString(LanguageBuilder.formPath("commands", "main", "nearhomes", "filtered-player", "home-string")).replace("%homecommand%", zHomes.getConfigYAML().getHomeCommand()).replace("%maincommand%", zHomes.getConfigYAML().getMainCommand()).replace("%radius%", String.valueOf(radius)).replace("%home%", home).replace("%player%", player == null || player.getName() == null ? "----" : player.getName());
    }

    public String getMainParseUsage() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "parse", "usage"));
    }

    public Component getMainParseOutput(@Nullable OfflinePlayer player, String parsed) {
        return TextFormatter.transform(player, this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "parse", "output")).replace("%parsed%", parsed));
    }

    public Component getMainParseOutput(String parsed) {
        return this.getMainParseOutput(null, parsed);
    }

    public String getMainPurgeUsage() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "purge", "usage"));
    }

    public String getMainPurgeOutput(int amount) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "purge", "output")).replace("%amount%", String.valueOf(amount));
    }

    public String getMainConverterUsage() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "converter", "usage"));
    }

    public String getMainConverterOutput() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "converter", "output"));
    }

    public String getMainConverterError() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "converter", "error"));
    }

    public String getMainExportOutput(String file) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "export", "output")).replace("%file%", file);
    }

    public String getMainExportError() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "export", "error"));
    }

    public String getMainImportUsage() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "import", "usage"));
    }

    public String getMainImportOutput(String file) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "import", "output")).replace("%file%", file);
    }

    public String getMainImportFileNotFound(String file) {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "import", "file-not-found")).replace("%file%", file);
    }

    public String getMainImportError() {
        return this.getString(zHomes.getConfigYAML().getMainCommand(), LanguageBuilder.formPath("commands", "main", "import", "error"));
    }

    public String getSethomeUsage() {
        return this.getString(zHomes.getConfigYAML().getSetHomeCommand(), LanguageBuilder.formPath("commands", "sethome", "usage"));
    }

    public String getSethomeOutput(String home) {
        return this.getString(zHomes.getConfigYAML().getSetHomeCommand(), LanguageBuilder.formPath("commands", "sethome", "output")).replace("%home%", home);
    }

    public String getSethomeLimitReached(OfflinePlayer player) {
        return this.getString(zHomes.getConfigYAML().getSetHomeCommand(), LanguageBuilder.formPath("commands", "sethome", "limit-reached")).replace("%limit%", String.valueOf(HomesUtils.getLimit(player)));
    }

    public String getDelhomeUsage() {
        return this.getString(zHomes.getConfigYAML().getDelHomeCommand(), LanguageBuilder.formPath("commands", "delhome", "usage"));
    }

    public String getDelhomeOutput(String home) {
        return this.getString(zHomes.getConfigYAML().getDelHomeCommand(), LanguageBuilder.formPath("commands", "delhome", "output")).replace("%home%", home);
    }

    public String getHomeUsage() {
        return this.getString(zHomes.getConfigYAML().getHomeCommand(), LanguageBuilder.formPath("commands", "home", "usage"));
    }

    public String getHomeOutput(String home) {
        return this.getString(zHomes.getConfigYAML().getHomeCommand(), LanguageBuilder.formPath("commands", "home", "output")).replace("%home%", home);
    }

    public String getHomeCantDimensionalTeleport() {
        return this.getString(zHomes.getConfigYAML().getHomeCommand(), LanguageBuilder.formPath("commands", "home", "cant-dimensional-teleport"));
    }

    public String getHomeRenameUsage() {
        return this.getString(zHomes.getConfigYAML().getHomeCommand(), LanguageBuilder.formPath("commands", "home", "rename", "usage"));
    }

    public String getHomeRenameOutput(String home, String newName) {
        return this.getString(zHomes.getConfigYAML().getHomeCommand(), LanguageBuilder.formPath("commands", "home", "rename", "output")).replace("%home%", home).replace("%newname%", newName);
    }

    public String getHomeRenameSameName() {
        return this.getString(zHomes.getConfigYAML().getHomeCommand(), LanguageBuilder.formPath("commands", "home", "rename", "same-name"));
    }

    public String getHomesOutputSelf(Player player) {
        return this.getString(zHomes.getConfigYAML().getHomesCommand(), LanguageBuilder.formPath("commands", "homes", "output")).replace("%homes%", HomesUtils.homes((OfflinePlayer)player)).replace("%amount%", String.valueOf(HomesUtils.numberOfHomes((OfflinePlayer)player)));
    }

    public String getHomesOutputOthers(OfflinePlayer player) {
        return this.getString(zHomes.getConfigYAML().getHomesCommand(), LanguageBuilder.formPath("commands", "homes", "others", "output")).replace("%homes%", HomesUtils.homes(player, true)).replace("%amount%", String.valueOf(HomesUtils.numberOfHomes(player))).replace("%player%", player == null || player.getName() == null ? "----" : player.getName());
    }

    public String getHomesHomeString(String home) {
        return this.getString(LanguageBuilder.formPath("commands", "homes", "home-string")).replace("%home%", home).replace("%homecommand%", zHomes.getConfigYAML().getHomeCommand());
    }

    public String getHomesHomeStringOthers(String home, String owner) {
        return this.getString(LanguageBuilder.formPath("commands", "homes", "others", "home-string")).replace("%home%", home).replace("%homecommand%", zHomes.getConfigYAML().getHomeCommand()).replace("%player%", owner);
    }

    public String getHomesInvalidPage() {
        return this.getString(zHomes.getConfigYAML().getHomesCommand(), LanguageBuilder.formPath("commands", "homes", "invalid-page"));
    }

    public static File getLanguageFolder() {
        return languageFolder;
    }

    public String getLanguageFileName() {
        return this.getFile().getName().replace(".yml", "");
    }

    public static void sendMessage(@Nullable CommandSender sender, String message) {
        if (sender != null) {
            sender.sendMessage(TextFormatter.transform((OfflinePlayer)(sender instanceof Player ? (Player)sender : null), message));
        }
    }

    public static void sendActionBar(CommandSender sender, String message) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(TextFormatter.transform(message));
            return;
        }
        Player player = (Player)sender;
        player.sendActionBar(TextFormatter.transform((OfflinePlayer)player, message));
    }

    @Override
    public String getString(String command, String path) {
        return this.getString(path).replace("%command%", command).replace("<command>", command);
    }

    private String t(String key, String englishDefault) {
        return this.translations().getOrDefault(key, englishDefault);
    }
}

