/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.commands;

import com.zhomes.api.event.player.ExecuteSethomeCommandEvent;
import com.zhomes.api.event.player.PreExecuteSethomeCommandEvent;
import java.util.List;
import me.yleoft.zHomes.hooks.HookRegistry;
import me.yleoft.zHomes.libs.zAPI.command.Command;
import me.yleoft.zHomes.utility.HomesUtils;
import me.yleoft.zHomes.zHomes;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class SethomeCommand
extends HomesUtils
implements Command {
    @Override
    @NotNull
    public String name() {
        return zHomes.getConfigYAML().getSetHomeCommand();
    }

    @Override
    public String description() {
        return zHomes.getConfigYAML().getSetHomeCommandDescription();
    }

    @Override
    public List<String> aliases() {
        return zHomes.getConfigYAML().getSetHomeCommandAliases();
    }

    @Override
    public int minArgs() {
        return 1;
    }

    @Override
    public String permission() {
        return zHomes.getConfigYAML().getSetHomeCommandPermission();
    }

    @Override
    public double cooldownTime() {
        return zHomes.getConfigYAML().getSetHomeCommandCooldown();
    }

    @Override
    public boolean playerOnly() {
        return true;
    }

    @Override
    public String usage(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        return zHomes.getLanguageYAML().getSethomeUsage();
    }

    @Override
    public boolean prexecute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull @NotNull String @NotNull [] args) {
        PreExecuteSethomeCommandEvent preevent = new PreExecuteSethomeCommandEvent((Player)sender);
        Bukkit.getPluginManager().callEvent((Event)preevent);
        return preevent.isCancelled();
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull @NotNull String @NotNull [] args) {
        Player player = (Player)sender;
        String home = args[0];
        ExecuteSethomeCommandEvent event = new ExecuteSethomeCommandEvent(player, home);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        home = event.getHome();
        if (!SethomeCommand.inMaxLimit(player)) {
            if (home.contains(":")) {
                this.message((CommandSender)player, zHomes.getLanguageYAML().getCantUse2Dot());
                return;
            }
            if (!SethomeCommand.hasHome((OfflinePlayer)player, home)) {
                if (HookRegistry.VAULT.canAfford(player, zHomes.getConfigYAML().getSetHomeCommandPermission(), zHomes.getConfigYAML().getSetHomeCommandCost())) {
                    SethomeCommand.addHome((OfflinePlayer)player, home, player.getLocation());
                    this.message((CommandSender)player, zHomes.getLanguageYAML().getSethomeOutput(home));
                }
            } else {
                this.message((CommandSender)player, zHomes.getLanguageYAML().getHomeAlreadyExist());
            }
        } else {
            this.message((CommandSender)player, zHomes.getLanguageYAML().getSethomeLimitReached((OfflinePlayer)player));
        }
    }
}

