/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.yleoft.zHomes.libs.zAPI.command.Parameter;
import me.yleoft.zHomes.libs.zAPI.command.SubCommand;
import me.yleoft.zHomes.libs.zAPI.player.PlayerHandler;
import me.yleoft.zHomes.storage.DatabaseEditor;
import me.yleoft.zHomes.utility.HomesUtils;
import me.yleoft.zHomes.zHomes;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainPurgeSubCommand
implements SubCommand {
    private static final String deleteAllSymbol = "*";
    private final Parameter playerParameter = new Parameter(){

        @Override
        @NotNull
        public String name() {
            return "player";
        }

        @Override
        @NotNull
        public List<String> aliases() {
            return List.of("u", "user", "p");
        }

        @Override
        public int minArgs() {
            return 1;
        }

        @Override
        public int maxArgs() {
            return 1;
        }

        @Override
        public Set<String> whitelist() {
            return Arrays.stream(Bukkit.getOfflinePlayers()).map(offlinePlayer -> offlinePlayer.getName() == null ? "" : offlinePlayer.getName()).collect(Collectors.toSet());
        }

        @Override
        @Nullable
        public String whitelistMessage() {
            return zHomes.getLanguageYAML().getCantFindPlayer();
        }

        @Override
        @NotNull
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] parameterArgs) {
            return Arrays.stream(Bukkit.getOfflinePlayers()).map(offlinePlayer -> offlinePlayer.getName() == null ? "" : offlinePlayer.getName()).toList();
        }
    };
    private final Parameter worldParameter = new Parameter(){

        @Override
        @NotNull
        public String name() {
            return "world";
        }

        @Override
        @NotNull
        public List<String> aliases() {
            return List.of("w");
        }

        @Override
        public int minArgs() {
            return 1;
        }

        @Override
        public int maxArgs() {
            return 1;
        }

        @Override
        public Set<String> whitelist() {
            return Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toSet());
        }

        @Override
        @Nullable
        public String whitelistMessage() {
            return Parameter.super.whitelistMessage();
        }

        @Override
        @NotNull
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] parameterArgs) {
            return Bukkit.getWorlds().stream().map(WorldInfo::getName).toList();
        }
    };
    private final Parameter startswithParameter = new Parameter(){

        @Override
        @NotNull
        public String name() {
            return "startswith";
        }

        @Override
        @NotNull
        public List<String> aliases() {
            return List.of("sw", "startwith");
        }

        @Override
        public int minArgs() {
            return 1;
        }

        @Override
        public int maxArgs() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] parameterArgs) {
            String[] playerArgs;
            String target = fullArgs[1];
            OfflinePlayer targetPlayer = null;
            if (!target.equals(MainPurgeSubCommand.deleteAllSymbol)) {
                targetPlayer = PlayerHandler.getOfflinePlayer(target);
            }
            if ((playerArgs = MainPurgeSubCommand.this.getParameter(sender, MainPurgeSubCommand.this.playerParameter)) != null) {
                targetPlayer = PlayerHandler.getOfflinePlayer(playerArgs[0]);
            }
            if (targetPlayer != null) {
                return HomesUtils.homesW(targetPlayer);
            }
            return List.of();
        }
    };
    private final Parameter endswithParameter = new Parameter(){

        @Override
        @NotNull
        public String name() {
            return "endswith";
        }

        @Override
        @NotNull
        public List<String> aliases() {
            return List.of("ew", "endwith");
        }

        @Override
        public int minArgs() {
            return 1;
        }

        @Override
        public int maxArgs() {
            return 1;
        }

        @Override
        @NotNull
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] parameterArgs) {
            String[] playerArgs;
            String target = fullArgs[1];
            OfflinePlayer targetPlayer = null;
            if (!target.equals(MainPurgeSubCommand.deleteAllSymbol)) {
                targetPlayer = PlayerHandler.getOfflinePlayer(target);
            }
            if ((playerArgs = MainPurgeSubCommand.this.getParameter(sender, MainPurgeSubCommand.this.playerParameter)) != null) {
                targetPlayer = PlayerHandler.getOfflinePlayer(playerArgs[0]);
            }
            if (targetPlayer != null) {
                return HomesUtils.homesW(targetPlayer);
            }
            return List.of();
        }
    };

    public MainPurgeSubCommand() {
        this.addParameter(this.playerParameter);
        this.addParameter(this.worldParameter);
        this.addParameter(this.startswithParameter);
        this.addParameter(this.endswithParameter);
    }

    @Override
    @NotNull
    public String name() {
        return "purge";
    }

    @Override
    public List<String> aliases() {
        return List.of("purgedata");
    }

    @Override
    public int minArgs() {
        return 1;
    }

    @Override
    public int maxArgs() {
        return 1;
    }

    @Override
    public String permission() {
        return zHomes.getConfigYAML().getMainCommandPurgePermission();
    }

    @Override
    public String usage(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        return zHomes.getLanguageYAML().getMainPurgeUsage();
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull @NotNull String @NotNull [] args) {
        String[] endswithArgs;
        String[] startswithArgs;
        String[] worldArgs;
        OfflinePlayer playerArg;
        String[] playerArgs;
        String target = args[0];
        DatabaseEditor.PurgeFilter.Builder filterBuilder = DatabaseEditor.PurgeFilter.builder();
        if (!target.equals(deleteAllSymbol)) {
            OfflinePlayer targetPlayer = PlayerHandler.getOfflinePlayer(target);
            if (targetPlayer == null) {
                this.message(sender, zHomes.getLanguageYAML().getCantFindPlayer());
                return;
            }
            filterBuilder.player(targetPlayer);
        }
        if ((playerArgs = this.getParameter(sender, this.playerParameter)) != null && (playerArg = PlayerHandler.getOfflinePlayer(playerArgs[0])) != null) {
            filterBuilder.player(playerArg);
        }
        if ((worldArgs = this.getParameter(sender, this.worldParameter)) != null && Bukkit.getWorld((String)worldArgs[0]) != null) {
            filterBuilder.world(Bukkit.getWorld((String)worldArgs[0]));
        }
        if ((startswithArgs = this.getParameter(sender, this.startswithParameter)) != null) {
            filterBuilder.homeStartsWith(startswithArgs[0]);
        }
        if ((endswithArgs = this.getParameter(sender, this.endswithParameter)) != null) {
            filterBuilder.homeEndsWith(endswithArgs[0]);
        }
        int affected = DatabaseEditor.purgeHomes(filterBuilder.build());
        this.message(sender, zHomes.getLanguageYAML().getMainPurgeOutput(affected));
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        return args.length > 1 ? List.of("-") : Stream.concat(Arrays.stream(Bukkit.getOfflinePlayers()).map(player -> player.getName() != null ? player.getName() : ""), Stream.of(deleteAllSymbol)).toList();
    }
}

