/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.commands;

import com.zhomes.api.event.player.ExecuteHomeCommandEvent;
import com.zhomes.api.event.player.PreExecuteHomeCommandEvent;
import java.util.ArrayList;
import java.util.List;
import me.yleoft.zHomes.commands.HomeRenameSubCommand;
import me.yleoft.zHomes.configuration.languages.LanguageBuilder;
import me.yleoft.zHomes.hooks.HookRegistry;
import me.yleoft.zHomes.libs.zAPI.command.Command;
import me.yleoft.zHomes.libs.zAPI.player.PlayerHandler;
import me.yleoft.zHomes.utility.HomesUtils;
import me.yleoft.zHomes.zHomes;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class HomeCommand
extends HomesUtils
implements Command {
    public HomeCommand() {
        this.addSubCommand(new HomeRenameSubCommand());
    }

    @Override
    @NotNull
    public String name() {
        return zHomes.getConfigYAML().getHomeCommand();
    }

    @Override
    public String description() {
        return zHomes.getConfigYAML().getHomeCommandDescription();
    }

    @Override
    public List<String> aliases() {
        return zHomes.getConfigYAML().getHomeCommandAliases();
    }

    @Override
    public int minArgs() {
        return 1;
    }

    @Override
    public boolean playerOnly() {
        return true;
    }

    @Override
    public String permission() {
        return zHomes.getConfigYAML().getHomeCommandPermission();
    }

    @Override
    public double cooldownTime() {
        return zHomes.getConfigYAML().getHomeCommandCooldown();
    }

    @Override
    public String bypassCooldownPermission() {
        return zHomes.getConfigYAML().getBypassCommandCooldownPermission(zHomes.getConfigYAML().getHomeCommandPermission());
    }

    @Override
    public String usage(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        return zHomes.getLanguageYAML().getHomeUsage();
    }

    @Override
    public boolean prexecute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull @NotNull String @NotNull [] args) {
        PreExecuteHomeCommandEvent preevent = new PreExecuteHomeCommandEvent((Player)sender);
        Bukkit.getPluginManager().callEvent((Event)preevent);
        return preevent.isCancelled();
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull @NotNull String @NotNull [] args) {
        Player player = (Player)sender;
        String home = args[0];
        if (home.contains(":")) {
            if (player.hasPermission(zHomes.getConfigYAML().getHomeOthersPermission())) {
                this.code2(player, home);
            } else {
                this.message((CommandSender)player, zHomes.getLanguageYAML().getCantUse2Dot());
            }
        } else {
            this.code1(player, home);
        }
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String[] fullArgs, @NotNull String[] args) {
        String[] as;
        OfflinePlayer t;
        ArrayList<String> completions = new ArrayList<String>();
        if (args[0].contains(":") && sender.hasPermission(zHomes.getConfigYAML().getHomeOthersPermission()) && (t = Bukkit.getOfflinePlayer((String)(as = args[0].split(":"))[0])) != null) {
            completions.addAll(HomeCommand.homesWDD(t));
        }
        if (completions.isEmpty() && sender instanceof Player) {
            Player player = (Player)sender;
            completions.addAll(HomeCommand.homesW((OfflinePlayer)player));
            if (player.hasPermission(zHomes.getConfigYAML().getHomeOthersPermission())) {
                Bukkit.getOnlinePlayers().forEach(on -> completions.add(on.getName() + ":"));
            }
        }
        if (sender.hasPermission(zHomes.getConfigYAML().getHomeRenamePermission())) {
            completions.add("rename");
        }
        return completions;
    }

    public void code1(Player p, String home) {
        ExecuteHomeCommandEvent event = new ExecuteHomeCommandEvent(p, home);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        home = event.getHome();
        if (HomeCommand.hasHome((OfflinePlayer)p, home)) {
            if (HookRegistry.VAULT.canAfford(p, zHomes.getConfigYAML().getHomeCommandPermission(), zHomes.getConfigYAML().getHomeCommandCost())) {
                HomeCommand.teleportPlayer(p, home);
            }
        } else {
            LanguageBuilder.sendMessage((CommandSender)p, zHomes.getLanguageYAML().getHomeDoesntExist());
        }
    }

    public void code2(Player p, String home) {
        ExecuteHomeCommandEvent event = new ExecuteHomeCommandEvent(p, home);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        String ofchome = event.getHome();
        if (ofchome == null || ofchome.isEmpty()) {
            return;
        }
        String[] homeS = ofchome.split(":");
        if (homeS.length < 2) {
            return;
        }
        String player = homeS[0];
        home = homeS[1];
        OfflinePlayer t = PlayerHandler.getOfflinePlayer(player);
        if (t == null) {
            return;
        }
        if (HomeCommand.hasHome(t, home)) {
            if (HookRegistry.VAULT.canAfford(p, zHomes.getConfigYAML().getHomeCommandPermission(), zHomes.getConfigYAML().getHomeCommandCost())) {
                HomeCommand.teleportPlayer(p, t, home);
            }
        } else {
            LanguageBuilder.sendMessage((CommandSender)p, zHomes.getLanguageYAML().getHomeDoesntExistOthers(t.getName()));
        }
    }
}

